/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import hepsim.HepSim;
import java.util.ArrayList;

public class Ls {
    public static void main(String[] args) {
        long tot = 0L;
        boolean simple_list = false;
        boolean simple_list_url = false;
        if (args.length > 0) {
            String surl = args[0].trim();
            String[] parts = surl.split("%");
            if (parts.length == 2) {
                surl = parts[0];
            } else if (parts.length > 2) {
                HepSim.ErrorMessage("HepSim does not support listing multiple datasets at the same time.");
                System.exit(1);
            }
            String[] surl_array = HepSim.urlRedirector(surl);
            if (surl_array != null) {
                surl = surl_array[0];
                if (surl_array.length > 1) {
                    System.out.println("\u001b[34mAvailable mirrors:\u001b[0m");
                    for (int j = 0; j < surl_array.length; ++j) {
                        System.err.print("\u001b[34m[" + Integer.toString(j) + "]" + "\u001b[0m");
                        System.out.println("  " + surl_array[j]);
                    }
                }
            }
            if (args.length == 2) {
                String s = args[1].trim();
                if (s.equals("simple")) {
                    simple_list = true;
                }
                if (s.equals("simple-url")) {
                    simple_list = true;
                    simple_list_url = true;
                }
                if (!s.equals("simple") && !s.equals("simple-url")) {
                    HepSim.ErrorMessage("HepSim does not recognize second argument. Should be \"simple\" or  \"simple-url\"");
                    System.exit(1);
                }
            }
            if (parts.length == 2) {
                surl = surl + "/" + parts[1];
            }
            if (surl.length() < 5) {
                HepSim.ErrorMessage("Exit! Wrong URL!");
                System.exit(1);
            }
            if (!HepSim.isValidURL(surl)) {
                HepSim.ErrorMessage("First argument is not valid URL. Exit!");
                System.exit(0);
            }
            if (!simple_list) {
                System.out.println("URL: " + surl);
                System.out.format("%7s%42s%13s\n", "Nr", "File name", "     bytes");
                int nlinse = 62;
                for (int j = 0; j < nlinse; ++j) {
                    System.out.print("-");
                }
                System.out.println("");
                ArrayList<ArrayList<String>> ar = HepSim.getArray(surl);
                ArrayList tmp = new ArrayList();
                for (int j = 0; j < ar.size(); ++j) {
                    ArrayList<String> s1 = ar.get(j);
                    String sfile = s1.get(0).trim();
                    String sizes = s1.get(1).trim();
                    long xs = Long.parseLong(sizes);
                    tot += xs;
                    System.out.format("%7s%42s%13s\n", Integer.toString(j + 1), sfile, sizes);
                }
                double xdd = (double)tot / 1048576.0;
                String fileSize = Integer.toString((int)xdd);
                for (int j = 0; j < nlinse; ++j) {
                    System.out.print("-");
                }
                System.out.println("");
                System.out.format("%7s%42s%9s%3s\n", "Summary:", "Nr of files: " + Integer.toString(ar.size()), fileSize, "MB");
            } else {
                ArrayList<ArrayList<String>> ar = HepSim.getArray(surl);
                ArrayList tmp = new ArrayList();
                for (int j = 0; j < ar.size(); ++j) {
                    ArrayList<String> s1 = ar.get(j);
                    String sfile = s1.get(0).trim();
                    if (!simple_list_url) {
                        System.out.println(sfile);
                    }
                    if (!simple_list_url) continue;
                    System.out.println(surl + "/" + sfile);
                }
            }
        } else {
            HepSim.ErrorMessage("Usage: It takes 1 argument:  URL of HepSim data sample! (or) ");
            HepSim.ErrorMessage(" When 2 arguments: \"[URL] simple\" -  prints file list without decoration");
            HepSim.ErrorMessage("                   \"[URL] simple-url\" - prints simple file list with URL");
            System.exit(1);
        }
    }
}

