/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class HepSim {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private static final int FILE_VERSION = 1;
    static final int BUFFER = 2048;
    private byte[] data;
    private static ZipInputStream zin;
    private static ZipFile zipFile;
    private long version = -1L;
    public static String hepsim_www;
    public static ArrayList<String> mirrors;

    public static boolean ping(String surl, int timeout) {
        surl = surl.replaceFirst("https", "http");
        try {
            URL url = new URL(surl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            if (code >= 200 && code < 410) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static String GetExecutionPath() {
        String absolutePath = HepSim.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        absolutePath = absolutePath.substring(0, absolutePath.lastIndexOf("/"));
        absolutePath = absolutePath.replaceAll("%20", " ");
        return absolutePath;
    }

    public static void Init() {
        String inifile = HepSim.GetExecutionPath() + File.separator + "mirrors.conf";
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(inifile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            while ((strLine = br.readLine()) != null) {
                String xline = strLine.trim();
                if (xline.length() < 2 || xline.startsWith("#")) continue;
                mirrors.add(xline);
            }
            br.close();
        }
        catch (IOException e) {
            mirrors.add(hepsim_www);
            System.out.println("# No file mirrors.conf file. Use default=" + hepsim_www);
        }
        if (mirrors.size() > 0) {
            for (int j = 0; j < mirrors.size(); ++j) {
                boolean response = HepSim.ping(mirrors.get(j), 30);
                if (!response) continue;
                hepsim_www = mirrors.get(j);
                System.out.println("HepSim server: " + hepsim_www);
                break;
            }
        }
    }

    public static ArrayList<ArrayList<String>> getArray(String file) {
        String files = "";
        URL url = null;
        if (file.startsWith("http") || file.startsWith("ftp")) {
            try {
                url = new URL(file + "/files.zip");
            }
            catch (MalformedURLException e) {
                HepSim.ErrorMessage("Error in accessing the URL=" + url.toString());
            }
            try {
                URLConnection urlConn = url.openConnection();
                urlConn.setUseCaches(false);
                zin = new ZipInputStream(urlConn.getInputStream());
                files = HepSim.fetchDescriptionURL("files");
                zin.close();
                zin = null;
            }
            catch (MalformedURLException e) {
                HepSim.ErrorMessage("Error: Malformed URL!");
                System.exit(1);
            }
            catch (IOException e) {
                HepSim.ErrorMessage("Error: The location of data sample was not found! Please check URL!");
                System.exit(1);
            }
        } else {
            HepSim.ErrorMessage("Wrong URL! It should start as http or ftp");
            System.exit(1);
        }
        String[] res = files.split("\n");
        ArrayList<ArrayList<String>> listOfLists = new ArrayList<ArrayList<String>>();
        for (int j = 0; j < res.length; ++j) {
            String[] xfiles;
            String xline = res[j].trim();
            if (xline.length() < 2 || xline.startsWith("#") || (xfiles = xline.split("\\s+")).length < 2) continue;
            String sfile = xfiles[1].trim();
            sfile = sfile.replace("\n", "");
            String size = xfiles[0].trim();
            ArrayList<String> out = new ArrayList<String>();
            out.add(sfile);
            out.add(size);
            listOfLists.add(out);
        }
        return listOfLists;
    }

    public static ArrayList<String> getList(String data) {
        ArrayList<ArrayList<String>> ar = HepSim.getArray(data);
        ArrayList<String> tmp = new ArrayList<String>();
        for (int j = 0; j < ar.size(); ++j) {
            ArrayList<String> s1 = ar.get(j);
            tmp.add(s1.get(0));
        }
        return tmp;
    }

    public static List<Integer> getRanges(ArrayList<String> list, String start, String end) {
        HashSet<String> tmp = new HashSet<String>();
        for (int j = 0; j < list.size(); ++j) {
            String s2;
            String[] parts2;
            String s1 = list.get(j);
            String[] parts1 = s1.split(start);
            if (parts1.length <= 1 || (parts2 = (s2 = parts1[1]).split(end)).length <= 1) continue;
            tmp.add(parts2[0]);
        }
        ArrayList slist = new ArrayList(tmp);
        ArrayList<Integer> ilist = new ArrayList<Integer>();
        for (int j = 0; j < slist.size(); ++j) {
            String sval = (String)slist.get(j);
            int foo = 0;
            try {
                foo = Integer.parseInt(sval);
            }
            catch (NumberFormatException e) {
                System.err.println("Error converting string:" + sval + " to integer");
            }
            ilist.add(new Integer(foo));
        }
        Collections.sort(ilist);
        return ilist;
    }

    public static ArrayList<String[]> getListArraySizes(String data) {
        ArrayList<ArrayList<String>> ar = HepSim.getArray(data);
        ArrayList<String[]> tmp = new ArrayList<String[]>();
        for (int j = 0; j < ar.size(); ++j) {
            ArrayList<String> s1 = ar.get(j);
            String[] tt = new String[]{s1.get(0), s1.get(1)};
            tmp.add(tt);
        }
        return tmp;
    }

    public static ArrayList<ArrayList<String>> getListSizes(String data) {
        return HepSim.getArray(data);
    }

    public static boolean isValidURL(String url) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        try {
            u.toURI();
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private static String fetchDescriptionURL(String key) {
        String tmp = "";
        try {
            ZipEntry zipEntry = zin.getNextEntry();
            while (zipEntry != null) {
                String sname = zipEntry.getName();
                if (sname.equals(key)) {
                    tmp = HepSim.getTextFromScanner(zin);
                }
                zin.closeEntry();
                zipEntry = zin.getNextEntry();
            }
            zin.close();
        }
        catch (IOException e) {
            HepSim.ErrorMessage("Error in openning the file?");
        }
        return tmp;
    }

    private static String getStringZip(String key) {
        String tmp = "";
        if (zipFile == null) {
            return tmp;
        }
        ZipEntry entry = null;
        try {
            entry = zipFile.getEntry(key);
            if (entry != null) {
                InputStream inputstream = zipFile.getInputStream(entry);
                Scanner sc = new Scanner(inputstream);
                while (sc.hasNextLine()) {
                    tmp = tmp + sc.nextLine() + "\n";
                }
            }
        }
        catch (IOException e) {
            tmp = "Self-description " + key + " is not found";
        }
        return tmp;
    }

    private static String getTextFromScanner(ZipInputStream xzin) {
        String tmp = "";
        Scanner sc = new Scanner(xzin);
        while (sc.hasNextLine()) {
            tmp = tmp + sc.nextLine() + "\n";
        }
        return tmp;
    }

    public static String[] urlRedirector(String surl) {
        HepSim.Init();
        if (surl.indexOf("http:") > -1 && surl.indexOf("info.php?") < 0) {
            return new String[]{surl};
        }
        int smart = 0;
        if (surl.indexOf("info.php?") > -1) {
            surl = surl.replace("info.php?", "geturl.php?");
            smart = 1;
        }
        if (surl.indexOf("http") < 0 && surl.indexOf("info.php?") < 0) {
            surl = hepsim_www + "/geturlmirrors.php?name=" + surl;
            smart = 2;
        }
        if (smart > 0) {
            try {
                String line;
                URL url = new URL(surl);
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                String NEWURL = "";
                while ((line = in.readLine()) != null) {
                    NEWURL = line;
                }
                in.close();
                NEWURL = NEWURL.trim();
                surl = NEWURL = NEWURL.replace("\n", "");
                String[] parts = surl.split(";");
                if (parts.length == 0) {
                    if (smart == 2) {
                        HepSim.ErrorMessage("Name of the dataset was not found.");
                    }
                    if (smart == 1) {
                        HepSim.ErrorMessage("URL to the Info page cannot find the dataset.");
                    }
                    return null;
                }
                return parts;
            }
            catch (MalformedURLException e) {
                HepSim.ErrorMessage("Connection problem with the HepSim repository.");
                System.out.println("MalformedURLException: " + e.getMessage());
                return null;
            }
            catch (IOException e) {
                HepSim.ErrorMessage("Connection problem with the HepSim repository.");
                System.out.println("I/O Error: " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static void ErrorMessage(String a) {
        System.err.println(ANSI_RED + a + ANSI_RESET);
    }

    public static void main(String[] args) {
        long tot = 0L;
        if (args.length > 0) {
            System.out.println("File name                size (kB)");
            ArrayList<ArrayList<String>> ar = HepSim.getArray(args[0]);
            ArrayList tmp = new ArrayList();
            for (int j = 0; j < ar.size(); ++j) {
                ArrayList<String> s1 = ar.get(j);
                String sfile = s1.get(0).trim();
                String sizes = s1.get(1).trim();
                long xs = Long.parseLong(sizes);
                tot += xs;
                System.out.println(sfile + "\t" + sizes);
            }
            double xdd = 0.001 * (double)tot;
            String fileSize = Integer.toString((int)xdd);
            System.out.println("\u001b[32m-> Summary: Nr of files=" + Integer.toString(ar.size()) + "  Total size=" + fileSize + " MB" + ANSI_RESET);
        }
    }

    static {
        hepsim_www = "http://atlaswww.hep.anl.gov/hepsim/";
        mirrors = new ArrayList();
    }

    private static class ColumnComparator
    implements Comparator<ArrayList<String>> {
        private ColumnComparator() {
        }

        @Override
        public int compare(ArrayList<String> ar1, ArrayList<String> ar2) {
            return ar1.get(0).compareTo(ar2.get(0));
        }
    }
}

