/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.LinkedList;

public abstract class GraphicsUtils {
    private static final FontRenderContext frc = new FontRenderContext(null, true, true);
    private static final double CIE_EPSILON = 0.008856451679035631;
    private static final double CIE_KAPPA = 903.2962962962963;
    private static final double[] XYZ_R_D50 = new double[]{0.964221, 1.0, 0.825211};
    private static final double XYZ_R_D50_U0 = 4.0 * XYZ_R_D50[0] / (XYZ_R_D50[0] + 15.0 * XYZ_R_D50[1] + 3.0 * XYZ_R_D50[2]);
    private static final double XYZ_R_D50_V0 = 9.0 * XYZ_R_D50[1] / (XYZ_R_D50[0] + 15.0 * XYZ_R_D50[1] + 3.0 * XYZ_R_D50[2]);
    private static final double[] MATRIX_SRGB2XYZ_D50 = new double[]{0.436052025, 0.385081593, 0.143087414, 0.222491598, 0.71688606, 0.060621486, 0.013929122, 0.097097002, 0.71418547};
    private static final double[] MATRIX_XYZ2SRGB_D50 = new double[]{3.1338561, -1.6168667, -0.4906146, -0.9787684, 1.9161415, 0.033454, 0.0719453, -0.2289914, 1.4052427};

    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static Shape getOutline(String text, Font font, float wrappingWidth, double alignment) {
        boolean wordWrap = true;
        if (wrappingWidth <= 0.0f) {
            wordWrap = false;
            wrappingWidth = Float.MAX_VALUE;
        }
        AttributedString string = new AttributedString(text);
        string.addAttribute(TextAttribute.FONT, font);
        AttributedCharacterIterator iterator = string.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        LinkedList<TextLayout> lines = new LinkedList<TextLayout>();
        while (measurer.getPosition() < text.length()) {
            int nextBreakPos = measurer.nextOffset(wrappingWidth);
            int lineBreakPos = text.indexOf(10, measurer.getPosition()) + 1;
            int breakPos = nextBreakPos;
            if (lineBreakPos > 0 && lineBreakPos < nextBreakPos) {
                breakPos = lineBreakPos;
            }
            TextLayout line = measurer.nextLayout(wrappingWidth, breakPos, false);
            lines.add(line);
        }
        if (!wordWrap) {
            float advanceMax = 0.0f;
            for (TextLayout line : lines) {
                advanceMax = Math.max(line.getAdvance(), advanceMax);
            }
            wrappingWidth = advanceMax;
        }
        AffineTransform txLinePos = new AffineTransform();
        Area outlineAllLines = null;
        for (TextLayout line : lines) {
            double dx = alignment * (double)(wrappingWidth - line.getAdvance());
            txLinePos.translate(dx, line.getAscent());
            Area outlineLine = new Area(line.getOutline(txLinePos));
            if (outlineAllLines == null) {
                outlineAllLines = outlineLine;
            } else {
                outlineAllLines.add(outlineLine);
            }
            txLinePos.translate(-dx, line.getDescent() + line.getLeading());
        }
        return outlineAllLines;
    }

    public static void fillPaintedShape(Graphics2D graphics, Shape shape, Paint paint, Rectangle2D paintBounds) {
        if (shape == null) {
            return;
        }
        if (paintBounds == null) {
            paintBounds = shape.getBounds2D();
        }
        AffineTransform txOrig = graphics.getTransform();
        graphics.translate(paintBounds.getX(), paintBounds.getY());
        graphics.scale(paintBounds.getWidth(), paintBounds.getHeight());
        Paint paintOld = null;
        if (paint != null) {
            paintOld = graphics.getPaint();
            graphics.setPaint(paint);
        }
        AffineTransform tx = AffineTransform.getScaleInstance(1.0 / paintBounds.getWidth(), 1.0 / paintBounds.getHeight());
        tx.translate(-paintBounds.getX(), -paintBounds.getY());
        graphics.fill(tx.createTransformedShape(shape));
        if (paintOld != null) {
            graphics.setPaint(paintOld);
        }
        graphics.setTransform(txOrig);
    }

    public static void drawPaintedShape(Graphics2D graphics, Shape shape, Paint paint, Rectangle2D paintBounds, Stroke stroke) {
        if (shape == null) {
            return;
        }
        if (stroke == null) {
            stroke = graphics.getStroke();
        }
        shape = stroke.createStrokedShape(shape);
        GraphicsUtils.fillPaintedShape(graphics, shape, paint, paintBounds);
    }

    public static double[] rgb2xyz(double[] rgb, double[] xyz) {
        int i;
        if (xyz == null) {
            xyz = new double[rgb.length];
        }
        double[] rgbLin = new double[rgb.length];
        for (i = 0; i < rgb.length; ++i) {
            rgbLin[i] = rgb[i] <= 0.04045 ? rgb[i] / 12.92 : Math.pow((rgb[i] + 0.055) / 1.055, 2.4);
        }
        for (i = 0; i < xyz.length; ++i) {
            xyz[i] = MATRIX_SRGB2XYZ_D50[i * 3 + 0] * rgbLin[0] + MATRIX_SRGB2XYZ_D50[i * 3 + 1] * rgbLin[1] + MATRIX_SRGB2XYZ_D50[i * 3 + 2] * rgbLin[2];
        }
        return xyz;
    }

    public static double[] luv2xyz(double[] luv, double[] xyz) {
        if (xyz == null) {
            xyz = new double[luv.length];
        }
        if (luv[0] > 8.0) {
            xyz[1] = (luv[0] + 16.0) / 116.0;
            xyz[1] = xyz[1] * xyz[1] * xyz[1];
        } else {
            xyz[1] = luv[0] / 903.2962962962963;
        }
        double a = luv[0] != 0.0 || luv[1] != 0.0 ? (52.0 * luv[0] / (luv[1] + 13.0 * luv[0] * XYZ_R_D50_U0) - 1.0) / 3.0 : 0.0;
        double b = -5.0 * xyz[1];
        double c = -0.3333333333333333;
        double d = luv[0] != 0.0 || luv[2] != 0.0 ? xyz[1] * (39.0 * luv[0] / (luv[2] + 13.0 * luv[0] * XYZ_R_D50_V0) - 5.0) : 0.0;
        xyz[0] = !MathUtils.almostEqual(a, c, 1.0E-15) ? (d - b) / (a - c) : 0.0;
        xyz[2] = xyz[0] * a + b;
        return xyz;
    }

    public static double[] xyz2rgb(double[] xyz, double[] rgb) {
        int i;
        if (rgb == null) {
            rgb = new double[xyz.length];
        }
        for (i = 0; i < xyz.length; ++i) {
            rgb[i] = MATRIX_XYZ2SRGB_D50[i * 3 + 0] * xyz[0] + MATRIX_XYZ2SRGB_D50[i * 3 + 1] * xyz[1] + MATRIX_XYZ2SRGB_D50[i * 3 + 2] * xyz[2];
        }
        for (i = 0; i < rgb.length; ++i) {
            rgb[i] = rgb[i] <= 0.0031308 ? 12.92 * rgb[i] : 1.055 * Math.pow(rgb[i], 0.4166666666666667) - 0.055;
        }
        return rgb;
    }

    public static double[] xyz2luv(double[] xyz, double[] luv) {
        double tmp = xyz[0] + 15.0 * xyz[1] + 3.0 * xyz[2];
        if (tmp == 0.0) {
            tmp = 1.0;
        }
        double u1 = 4.0 * xyz[0] / tmp;
        double v1 = 9.0 * xyz[1] / tmp;
        double yr = xyz[1] / XYZ_R_D50[1];
        double ur = 4.0 * XYZ_R_D50[0] / (XYZ_R_D50[0] + 15.0 * XYZ_R_D50[1] + 3.0 * XYZ_R_D50[2]);
        double vr = 9.0 * XYZ_R_D50[1] / (XYZ_R_D50[0] + 15.0 * XYZ_R_D50[1] + 3.0 * XYZ_R_D50[2]);
        if (luv == null) {
            luv = new double[xyz.length];
        }
        luv[0] = yr > 0.008856451679035631 ? 116.0 * Math.pow(yr, 0.3333333333333333) - 16.0 : 903.2962962962963 * yr;
        luv[1] = 13.0 * luv[0] * (u1 - ur);
        luv[2] = 13.0 * luv[0] * (v1 - vr);
        return luv;
    }

    public static double[] rgb2luv(double[] rgb, double[] luv) {
        double[] xyz = GraphicsUtils.rgb2xyz(rgb, null);
        return GraphicsUtils.xyz2luv(xyz, luv);
    }

    public static double[] luv2rgb(double[] luv, double[] rgb) {
        double[] xyz = GraphicsUtils.luv2xyz(luv, null);
        return GraphicsUtils.xyz2rgb(xyz, rgb);
    }

    public static Color blend(Color color1, Color color2, double weight) {
        double w2 = MathUtils.limit(weight, 0.0, 1.0);
        double w1 = 1.0 - w2;
        int r = (int)Math.round(w1 * (double)color1.getRed() + w2 * (double)color2.getRed());
        int g = (int)Math.round(w1 * (double)color1.getGreen() + w2 * (double)color2.getGreen());
        int b = (int)Math.round(w1 * (double)color1.getBlue() + w2 * (double)color2.getBlue());
        int a = (int)Math.round(w1 * (double)color1.getAlpha() + w2 * (double)color2.getAlpha());
        return new Color(r, g, b, a);
    }

    public static Color deriveWithAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color deriveDarker(Color color) {
        return GraphicsUtils.deriveWithAlpha(GraphicsUtils.blend(color, Color.BLACK, 0.5), color.getAlpha());
    }

    public static Color deriveBrighter(Color color) {
        return GraphicsUtils.deriveWithAlpha(GraphicsUtils.blend(color, Color.WHITE, 0.5), color.getAlpha());
    }
}

