/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.ui;

import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import javax.swing.JPanel;

public class DrawablePanel
extends JPanel {
    private static final long serialVersionUID = 1036506991203257170L;
    private final Drawable drawable;
    private boolean antialiased;

    public DrawablePanel(Drawable drawable) {
        this.drawable = drawable;
        this.setOpaque(false);
        this.antialiased = true;
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isVisible()) {
            Graphics2D graphics = (Graphics2D)g;
            if (this.isAntialiased()) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.getDrawable().draw(new DrawingContext(graphics));
        }
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.getDrawable().setBounds(bounds);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.getDrawable().setBounds(0.0, 0.0, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dims = super.getPreferredSize();
        Dimension2D dimsPlot = this.getDrawable().getPreferredSize();
        dims.setSize(dimsPlot);
        return dims;
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }
}

