/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.IndexedColorMapper;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class RandomColors
extends IndexedColorMapper {
    private static final long serialVersionUID = -4518470000665474457L;
    private static final int NUM_COMPARISONS = 4;
    private static final double MIN_DIST = 0.3;
    private final Map<Integer, Color> colorCache;
    private final Random random = new Random();
    private final float[] colorVariance;

    public RandomColors() {
        this.colorCache = new LinkedHashMap<Integer, Color>();
        this.colorVariance = new float[]{0.0f, 1.0f, 0.75f, 0.25f, 0.25f, 0.75f};
    }

    public RandomColors(long seed) {
        this();
        this.random.setSeed(seed);
    }

    @Override
    public Paint get(int index) {
        Color r;
        boolean match;
        Integer key = index;
        if (this.colorCache.containsKey(key)) {
            return this.colorCache.get(key);
        }
        block0: do {
            r = this.getRandomColor();
            match = true;
            Iterator<Color> colors = this.colorCache.values().iterator();
            for (int i = 0; i < 4 && colors.hasNext(); ++i) {
                Color prev = colors.next();
                if (!(RandomColors.distanceSq(r, prev) < 0.09)) continue;
                match = false;
                continue block0;
            }
        } while (!match);
        this.colorCache.put(key, r);
        return r;
    }

    private Color getRandomColor() {
        float[] colorVariance = this.getColorVariance();
        float hue = colorVariance[0] + colorVariance[1] * this.random.nextFloat();
        float saturation = colorVariance[2] + colorVariance[3] * this.random.nextFloat();
        float brightness = colorVariance[4] + colorVariance[5] * this.random.nextFloat();
        return Color.getHSBColor(hue, MathUtils.limit(saturation, 0.0f, 1.0f), MathUtils.limit(brightness, 0.0f, 1.0f));
    }

    private static double distanceSq(Color a, Color b) {
        double rMean = (double)(a.getRed() + b.getRed()) / 256.0 / 2.0;
        double dr = (double)(a.getRed() - b.getRed()) / 256.0;
        double dg = (double)(a.getGreen() - b.getGreen()) / 256.0;
        double db = (double)(a.getBlue() - b.getBlue()) / 256.0;
        double d = (2.0 + rMean) * dr * dr + 4.0 * dg * dg + (3.0 - rMean) * db * db;
        return d / 9.0;
    }

    public float[] getColorVariance() {
        return this.colorVariance;
    }

    public void setColorVariance(float[] colorVariance) {
        System.arraycopy(colorVariance, 0, this.colorVariance, 0, this.colorVariance.length);
    }
}

