/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.AbstractColorMapper;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Paint;

public abstract class IndexedColorMapper
extends AbstractColorMapper<Integer> {
    private static final long serialVersionUID = 553890535328678411L;

    public abstract Paint get(int var1);

    @Override
    public Paint get(Number index) {
        return this.get(index.intValue());
    }

    @Override
    protected Integer applyMode(Integer index, Integer rangeMin, Integer rangeMax) {
        if (index >= rangeMin && index <= rangeMax) {
            return index;
        }
        ColorMapper.Mode mode = this.getMode();
        if (mode == ColorMapper.Mode.REPEAT) {
            return MathUtils.limit(index, rangeMin, rangeMax);
        }
        if (mode == ColorMapper.Mode.CIRCULAR) {
            int range = rangeMax - rangeMin + 1;
            int i = index % range;
            if (i < 0) {
                i += range;
            }
            return i + rangeMin;
        }
        return null;
    }
}

