/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.data.DataWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public final class DataWriterFactory
extends AbstractIOFactory<DataWriter> {
    private static DataWriterFactory instance;

    private DataWriterFactory() throws IOException {
        super("datawriters.properties");
    }

    public static DataWriterFactory getInstance() {
        if (instance == null) {
            try {
                instance = new DataWriterFactory();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    @Override
    public DataWriter get(String mimeType) {
        DataWriter writer = null;
        Class clazz = this.getTypeClass(mimeType);
        try {
            if (clazz != null) {
                Constructor constructor = clazz.getDeclaredConstructor(String.class);
                writer = (DataWriter)constructor.newInstance(mimeType);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (writer == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", mimeType));
        }
        return writer;
    }
}

