/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics;

import java.io.Serializable;
import java.util.Locale;

public abstract class Insets2D
implements Serializable {
    private static final long serialVersionUID = 8685228413052838087L;

    public abstract double getTop();

    public abstract double getLeft();

    public abstract double getBottom();

    public abstract double getRight();

    public double getHorizontal() {
        return this.getRight() + this.getLeft();
    }

    public double getVertical() {
        return this.getTop() + this.getBottom();
    }

    public abstract void setInsets(Insets2D var1);

    public abstract void setInsets(double var1, double var3, double var5, double var7);

    public static class Double
    extends Insets2D {
        private static final long serialVersionUID = -6637052175330595647L;
        private double top;
        private double left;
        private double bottom;
        private double right;

        public Double() {
            this(0.0);
        }

        public Double(double inset) {
            this(inset, inset, inset, inset);
        }

        public Double(double top, double left, double bottom, double right) {
            this.setInsets(top, left, bottom, right);
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        @Override
        public void setInsets(Insets2D insets) {
            if (insets == null) {
                return;
            }
            this.setInsets(insets.getTop(), insets.getLeft(), insets.getBottom(), insets.getRight());
        }

        @Override
        public void setInsets(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public String toString() {
            return String.format(Locale.US, "%s[top=%f, left=%f, bottom=%f, right=%f]", this.getClass().getName(), this.top, this.left, this.bottom, this.right);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Insets2D)) {
                return false;
            }
            Insets2D insets = (Insets2D)obj;
            return this.getTop() == insets.getTop() && this.getLeft() == insets.getLeft() && this.getBottom() == insets.getBottom() && this.getRight() == insets.getRight();
        }

        public int hashCode() {
            long bits = java.lang.Double.doubleToLongBits(this.getTop());
            bits += java.lang.Double.doubleToLongBits(this.getLeft()) * 37L;
            bits += java.lang.Double.doubleToLongBits(this.getBottom()) * 43L;
            return (int)(bits += java.lang.Double.doubleToLongBits(this.getRight()) * 47L) ^ (int)(bits >> 32);
        }
    }
}

