/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.XYPlot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;

final class UpdateTask
implements ActionListener {
    private final DataTable data;
    private final Plot plot;
    private final JComponent component;
    private Method getTotalPhysicalMemorySize;
    private Method getFreePhysicalMemorySize;

    public UpdateTask(DataTable data, XYPlot plot, JComponent comp) {
        this.data = data;
        this.plot = plot;
        this.component = comp;
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            this.getTotalPhysicalMemorySize = osBean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            this.getTotalPhysicalMemorySize.setAccessible(true);
            this.getFreePhysicalMemorySize = osBean.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
            this.getFreePhysicalMemorySize.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.component.isVisible()) {
            return;
        }
        double time = System.currentTimeMillis();
        long memSysTotal = 0L;
        long memSysFree = 0L;
        long memSysUsed = 0L;
        if (this.getTotalPhysicalMemorySize != null && this.getFreePhysicalMemorySize != null) {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            try {
                memSysTotal = (Long)this.getTotalPhysicalMemorySize.invoke((Object)osBean, new Object[0]);
                memSysFree = (Long)this.getFreePhysicalMemorySize.invoke((Object)osBean, new Object[0]);
                memSysUsed = memSysTotal - memSysFree;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        long memVmTotal = Runtime.getRuntime().totalMemory();
        long memVmFree = Runtime.getRuntime().freeMemory();
        long memVmUsed = memVmTotal - memVmFree;
        this.data.add(Double.valueOf(time), Long.valueOf(memSysUsed / 1024L / 1024L), Long.valueOf(memVmTotal / 1024L / 1024L), Long.valueOf(memVmUsed / 1024L / 1024L));
        this.data.remove(0);
        Column<?> col1 = this.data.getColumn(0);
        this.plot.getAxis("x").setRange(col1.getStatistics("min"), col1.getStatistics("max"));
        Column<?> col3 = this.data.getColumn(2);
        this.plot.getAxis("y").setRange(0, Math.max((double)(memSysTotal / 1024L / 1024L), col3.getStatistics("max")));
        this.component.repaint();
    }
}

