/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.statistics;

import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.statistics.AbstractHistogram2D;
import de.erichseifert.gral.graphics.Orientation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Histogram2D
extends AbstractHistogram2D {
    private static final long serialVersionUID = -4841658606362408312L;
    private final Orientation orientation;
    private final List<Number[]> breaks;
    private final List<long[]> cellList;
    private transient Map<Integer, Long> cacheMin;
    private transient Map<Integer, Long> cacheMax;

    private Histogram2D(DataSource data, Orientation orientation) {
        super(data);
        this.orientation = orientation;
        this.breaks = new ArrayList<Number[]>();
        this.cellList = new ArrayList<long[]>();
        this.cacheMin = new HashMap<Integer, Long>();
        this.cacheMax = new HashMap<Integer, Long>();
    }

    public Histogram2D(DataSource data, Orientation orientation, int breakCount) {
        this(data, orientation);
        int count = this.getData().getColumnCount();
        if (orientation == Orientation.HORIZONTAL) {
            count = this.getData().getRowCount();
        }
        for (int index = 0; index < count; ++index) {
            double max;
            double min;
            if (orientation == Orientation.HORIZONTAL) {
                min = ((Number)((Object)this.getData().getRowStatistics("min").get(0, index))).doubleValue();
                max = ((Number)((Object)this.getData().getRowStatistics("max").get(0, index))).doubleValue();
            } else {
                min = ((Number)((Object)this.getData().getColumnStatistics("min").get(index, 0))).doubleValue();
                max = ((Number)((Object)this.getData().getColumnStatistics("max").get(index, 0))).doubleValue();
            }
            double delta = (max - min + Double.MIN_VALUE) / (double)breakCount;
            Double[] breaks = new Double[breakCount + 1];
            for (int i = 0; i < breaks.length; ++i) {
                breaks[i] = min + (double)i * delta;
            }
            this.breaks.add(breaks);
        }
        this.dataUpdated(this.getData(), new DataChangeEvent[0]);
    }

    public Histogram2D(DataSource data, Orientation orientation, Number[] ... breaks) {
        this(data, orientation);
        int count = this.getData().getColumnCount();
        if (orientation == Orientation.HORIZONTAL) {
            count = this.getData().getRowCount();
        }
        if (breaks.length != count) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid number of breaks: got {0,number,integer}, expected {1,number,integer}.", breaks.length, count));
        }
        Collections.addAll(this.breaks, breaks);
        this.dataUpdated(this.getData(), new DataChangeEvent[0]);
    }

    @Override
    protected void rebuildCells() {
        this.cellList.clear();
        this.cacheMin.clear();
        this.cacheMax.clear();
        int breakIndex = 0;
        for (Number[] brk : this.breaks) {
            long[] cells = new long[brk.length - 1];
            long colMin = Long.MAX_VALUE;
            long colMax = Long.MIN_VALUE;
            Iterable<Object> data = this.orientation == Orientation.VERTICAL ? this.getData().getColumn(breakIndex) : this.getData().getRecord(breakIndex);
            block1: for (Comparable comparable : data) {
                if (!(comparable instanceof Number)) continue;
                Number numericCell = (Number)((Object)comparable);
                double val = numericCell.doubleValue();
                for (int i = 0; i < brk.length - 1; ++i) {
                    if (!(val >= brk[i].doubleValue()) || !(val < brk[i + 1].doubleValue())) continue;
                    int n = i;
                    cells[n] = cells[n] + 1L;
                    if (cells[i] > colMax) {
                        colMax = cells[i];
                    }
                    if (cells[i] >= colMin) continue block1;
                    colMin = cells[i];
                    continue block1;
                }
            }
            this.cellList.add(cells);
            this.cacheMin.put(breakIndex, colMin);
            this.cacheMax.put(breakIndex, colMax);
            ++breakIndex;
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Number[] getCellLimits(int col, int cell) {
        Number[] breaks = this.breaks.get(col);
        Number lower = breaks[cell];
        Number upper = breaks[cell + 1];
        return new Number[]{lower, upper};
    }

    @Override
    public Comparable<?> get(int col, int row) {
        return this.cellList.get(col)[row];
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        for (long[] cells : this.cellList) {
            rowCount = Math.max(cells.length, rowCount);
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.cellList.size();
    }

    @Override
    public Class<? extends Comparable<?>>[] getColumnTypes() {
        Object[] types = new Class[this.getColumnCount()];
        Arrays.fill(types, Long.class);
        return types;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cacheMin = new HashMap<Integer, Long>();
        this.cacheMax = new HashMap<Integer, Long>();
    }
}

