/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class DataSeries
extends AbstractDataSource
implements DataListener {
    private static final long serialVersionUID = 5568085894125740972L;
    private final DataSource data;
    private final List<Integer> cols;

    public DataSeries(DataSource data, int ... cols) {
        this(null, data, cols);
    }

    public DataSeries(String name, DataSource data, int ... cols) {
        super(name, new Class[0]);
        Class[] types;
        this.data = data;
        this.cols = new ArrayList<Integer>();
        this.data.addDataListener(this);
        Class<? extends Comparable<?>>[] typesOrig = data.getColumnTypes();
        if (cols.length > 0) {
            types = new Class[cols.length];
            int t = 0;
            for (int colIndex : cols) {
                this.cols.add(colIndex);
                types[t++] = typesOrig[colIndex];
            }
        } else {
            for (int colIndex = 0; colIndex < data.getColumnCount(); ++colIndex) {
                this.cols.add(colIndex);
            }
            types = typesOrig;
        }
        this.setColumnTypes(types);
    }

    @Override
    public Comparable<?> get(int col, int row) {
        try {
            int dataCol = this.cols.get(col);
            return this.data.get(dataCol, row);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.cols.size();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.notifyDataAdded(events);
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.notifyDataUpdated(events);
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.notifyDataRemoved(events);
    }

    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.data.addDataListener(this);
    }
}

