/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.ui;

import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.util.Messages;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.filechooser.FileFilter;

public class DrawableWriterFilter
extends FileFilter {
    private final IOCapabilities capabilities;

    public DrawableWriterFilter(IOCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String ext = DrawableWriterFilter.getExtension(f).toLowerCase();
        for (String extension : this.capabilities.getExtensions()) {
            if (!extension.equals(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(Messages.getString("IO.formatDescription"), this.capabilities.getFormat(), this.capabilities.getName());
    }

    public IOCapabilities getWriterCapabilities() {
        return this.capabilities;
    }

    private static String getExtension(File f) {
        String name = f.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == name.length() - 1) {
            return "";
        }
        return name.substring(lastDot + 1);
    }
}

