/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SizeablePointRenderer
extends DefaultPointRenderer2D {
    private static final long serialVersionUID = 3276439387457161307L;
    private int column = 2;

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public Shape getPointShape(PointData data) {
        Shape shape = this.getShape();
        Row row = data.row;
        int colSize = this.getColumn();
        if (colSize >= row.size() || colSize < 0 || !row.isColumnNumeric(colSize)) {
            return shape;
        }
        Number value = (Number)((Object)row.get(colSize));
        double size = DataUtils.getValueOrDefault(value, Double.NaN);
        if (!MathUtils.isCalculatable(size) || size <= 0.0) {
            return null;
        }
        if (size != 1.0) {
            AffineTransform tx = AffineTransform.getScaleInstance(size, size);
            shape = tx.createTransformedShape(shape);
        }
        return shape;
    }
}

