/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;

public class LabelPointRenderer
extends DefaultPointRenderer2D {
    private static final long serialVersionUID = -2612520977245369774L;
    private int column = 1;
    private Format format = NumberFormat.getInstance();
    private Font font = Font.decode(null);
    private double alignmentX = 0.5;
    private double alignmentY = 0.5;

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public double getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(double alignmentX) {
        this.alignmentX = alignmentX;
    }

    public double getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(double alignmentY) {
        this.alignmentY = alignmentY;
    }

    @Override
    public Shape getPointShape(PointData data) {
        Row row = data.row;
        int colLabel = this.getColumn();
        if (colLabel >= row.size()) {
            return null;
        }
        Comparable<?> labelValue = row.get(colLabel);
        if (labelValue == null) {
            return null;
        }
        Format format = this.getFormat();
        Font font = this.getFont();
        String text = format.format(labelValue);
        double alignment = this.getAlignmentX();
        Shape shape = GraphicsUtils.getOutline(text, font, 0.0f, alignment);
        double alignX = this.getAlignmentX();
        double alignY = this.getAlignmentY();
        Rectangle2D bounds = shape.getBounds2D();
        AffineTransform tx = AffineTransform.getTranslateInstance(-alignX * bounds.getWidth(), alignY * bounds.getHeight());
        shape = tx.createTransformedShape(shape);
        return shape;
    }
}

