/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.points;

import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.SingleColor;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;

public abstract class AbstractPointRenderer
implements PointRenderer,
Serializable {
    private static final long serialVersionUID = -408976260196287753L;
    private Shape shape = new Rectangle2D.Double(-2.5, -2.5, 5.0, 5.0);
    private ColorMapper color = new SingleColor(Color.BLACK);
    private boolean valueVisible = false;
    private int valueColumn = 1;
    private Format valueFormat;
    private Location valueLocation = Location.CENTER;
    private double valueAlignmentX = 0.5;
    private double valueAlignmentY = 0.5;
    private double valueRotation = 0.0;
    private double valueDistance = 1.0;
    private ColorMapper valueColor = new SingleColor(Color.BLACK);
    private Font valueFont = Font.decode(null);
    private boolean errorVisible = false;
    private int errorColumnTop = 2;
    private int errorColumnBottom = 3;
    private ColorMapper errorColor = new SingleColor(Color.BLACK);
    private Shape errorShape = new Line2D.Double(-2.0, 0.0, 2.0, 0.0);
    private transient Stroke errorStroke = new BasicStroke(1.0f);

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.errorStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.errorStroke));
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Override
    public ColorMapper getColor() {
        return this.color;
    }

    @Override
    public void setColor(ColorMapper color) {
        this.color = color;
    }

    @Override
    public void setColor(Paint color) {
        this.setColor(new SingleColor(color));
    }

    @Override
    public boolean isValueVisible() {
        return this.valueVisible;
    }

    @Override
    public void setValueVisible(boolean valueVisible) {
        this.valueVisible = valueVisible;
    }

    @Override
    public int getValueColumn() {
        return this.valueColumn;
    }

    @Override
    public void setValueColumn(int columnIndex) {
        this.valueColumn = columnIndex;
    }

    @Override
    public Format getValueFormat() {
        return this.valueFormat;
    }

    @Override
    public void setValueFormat(Format format) {
        this.valueFormat = format;
    }

    @Override
    public Location getValueLocation() {
        return this.valueLocation;
    }

    @Override
    public void setValueLocation(Location location) {
        this.valueLocation = location;
    }

    @Override
    public double getValueAlignmentX() {
        return this.valueAlignmentX;
    }

    @Override
    public void setValueAlignmentX(double alignmentX) {
        this.valueAlignmentX = alignmentX;
    }

    @Override
    public double getValueAlignmentY() {
        return this.valueAlignmentY;
    }

    @Override
    public void setValueAlignmentY(double alignmentY) {
        this.valueAlignmentY = alignmentY;
    }

    @Override
    public double getValueRotation() {
        return this.valueRotation;
    }

    @Override
    public void setValueRotation(double angle) {
        this.valueRotation = angle;
    }

    @Override
    public double getValueDistance() {
        return this.valueDistance;
    }

    @Override
    public void setValueDistance(double distance) {
        this.valueDistance = distance;
    }

    @Override
    public ColorMapper getValueColor() {
        return this.valueColor;
    }

    @Override
    public void setValueColor(ColorMapper color) {
        this.valueColor = color;
    }

    @Override
    public void setValueColor(Paint color) {
        this.setValueColor(new SingleColor(color));
    }

    @Override
    public Font getValueFont() {
        return this.valueFont;
    }

    @Override
    public void setValueFont(Font font) {
        this.valueFont = font;
    }

    @Override
    public boolean isErrorVisible() {
        return this.errorVisible;
    }

    @Override
    public void setErrorVisible(boolean errorVisible) {
        this.errorVisible = errorVisible;
    }

    @Override
    public int getErrorColumnTop() {
        return this.errorColumnTop;
    }

    @Override
    public void setErrorColumnTop(int columnIndex) {
        this.errorColumnTop = columnIndex;
    }

    @Override
    public int getErrorColumnBottom() {
        return this.errorColumnBottom;
    }

    @Override
    public void setErrorColumnBottom(int columnIndex) {
        this.errorColumnBottom = columnIndex;
    }

    @Override
    public ColorMapper getErrorColor() {
        return this.errorColor;
    }

    @Override
    public void setErrorColor(ColorMapper color) {
        this.errorColor = color;
    }

    @Override
    public void setErrorColor(Paint color) {
        this.setErrorColor(new SingleColor(color));
    }

    @Override
    public Shape getErrorShape() {
        return this.errorShape;
    }

    @Override
    public void setErrorShape(Shape shape) {
        this.errorShape = shape;
    }

    @Override
    public Stroke getErrorStroke() {
        return this.errorStroke;
    }

    @Override
    public void setErrorStroke(Stroke stroke) {
        this.errorStroke = stroke;
    }
}

