/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.lines.AbstractLineRenderer2D;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class DefaultLineRenderer2D
extends AbstractLineRenderer2D {
    private static final long serialVersionUID = -1728830281555843667L;
    private static final int INITIAL_LINE_CAPACITY = 10000;

    @Override
    public Drawable getLine(List<DataPoint> points, final Shape shape) {
        AbstractDrawable d = new AbstractDrawable(){
            private static final long serialVersionUID = 7995515716470892483L;

            @Override
            public void draw(DrawingContext context) {
                Paint paint = DefaultLineRenderer2D.this.getColor();
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
            }
        };
        return d;
    }

    @Override
    public Shape getLineShape(List<DataPoint> points) {
        Path2D.Double shape = new Path2D.Double(1, 10000);
        for (DataPoint point : points) {
            Point2D pos = point.position.getPoint2D();
            if (shape.getCurrentPoint() == null) {
                ((Path2D)shape).moveTo(pos.getX(), pos.getY());
                continue;
            }
            ((Path2D)shape).lineTo(pos.getX(), pos.getY());
        }
        return this.stroke(shape);
    }
}

