/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.ContinuousColorMapper;

public abstract class ScaledContinuousColorMapper
extends ContinuousColorMapper {
    private static final long serialVersionUID = 323911118647457851L;
    private double offset;
    private double scale;

    public ScaledContinuousColorMapper() {
        this(0.0, 1.0);
    }

    public ScaledContinuousColorMapper(double offset, double scale) {
        this.offset = offset;
        this.scale = scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setRange(double start, double end) {
        this.setOffset(start);
        this.setScale(end - start);
    }

    protected Double scale(double value) {
        return (value - this.getOffset()) / this.getScale();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScaledContinuousColorMapper)) {
            return false;
        }
        ScaledContinuousColorMapper cm = (ScaledContinuousColorMapper)obj;
        return this.getOffset() == cm.getOffset() && this.getScale() == cm.getScale() && this.getMode() == cm.getMode();
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getOffset());
        return (int)(bits ^= Double.doubleToLongBits(this.getScale()) * 31L) ^ (int)(bits >> 32);
    }
}

