/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ScaledContinuousColorMapper;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LinearGradient
extends ScaledContinuousColorMapper {
    private static final long serialVersionUID = 4256873420364549677L;
    private final List<Color> colors = new ArrayList<Color>();

    public LinearGradient(Color color1, Color ... colors) {
        this.colors.add(color1);
        this.colors.addAll(Arrays.asList(colors));
    }

    @Override
    public Paint get(double value) {
        int colorMax;
        Double v = this.scale(value);
        if (!MathUtils.isCalculatable(v = this.applyMode(v, 0.0, 1.0))) {
            return null;
        }
        double x = v;
        double pos = MathUtils.limit(x * (double)(colorMax = this.colors.size() - 1), 0.0, (double)colorMax);
        if (pos == 0.0) {
            return this.colors.get(0);
        }
        if (pos == (double)colorMax) {
            return this.colors.get(colorMax);
        }
        double fract = pos - (double)((int)pos);
        Color color1 = this.colors.get((int)pos);
        if (fract == 0.0) {
            return color1;
        }
        double fractInv = 1.0 - fract;
        Color color2 = this.colors.get((int)pos + 1);
        double r = fractInv * (double)color1.getRed() + fract * (double)color2.getRed();
        double g = fractInv * (double)color1.getGreen() + fract * (double)color2.getGreen();
        double b = fractInv * (double)color1.getBlue() + fract * (double)color2.getBlue();
        double a = fractInv * (double)color1.getAlpha() + fract * (double)color2.getAlpha();
        return new Color((int)Math.round(r), (int)Math.round(g), (int)Math.round(b), (int)Math.round(a));
    }

    @Override
    public void setMode(ColorMapper.Mode mode) {
        super.setMode(mode);
    }

    public List<Color> getColors() {
        return Collections.unmodifiableList(this.colors);
    }
}

