/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.axes;

import de.erichseifert.gral.plots.axes.AbstractAxisRenderer2D;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.util.MathUtils;
import java.util.List;
import java.util.Set;

public class LogarithmicRenderer2D
extends AbstractAxisRenderer2D {
    private static final long serialVersionUID = 6360029510782348529L;

    @Override
    public double worldToView(Axis axis, Number value, boolean extrapolate) {
        LogarithmicRenderer2D.checkAxisBounds(axis);
        double min = axis.getMin().doubleValue();
        double max = axis.getMax().doubleValue();
        double val = value.doubleValue();
        if (!extrapolate) {
            if (val <= min) {
                return 0.0;
            }
            if (val >= max) {
                return this.getShapeLength();
            }
        }
        double minLog = min > 0.0 ? Math.log10(min) : 0.0;
        double maxLog = max > 0.0 ? Math.log10(max) : 1.0;
        return (Math.log10(val) - minLog) * this.getShapeLength() / (maxLog - minLog);
    }

    @Override
    public Number viewToWorld(Axis axis, double value, boolean extrapolate) {
        LogarithmicRenderer2D.checkAxisBounds(axis);
        double min = axis.getMin().doubleValue();
        double max = axis.getMax().doubleValue();
        if (!extrapolate) {
            if (value <= 0.0) {
                return min;
            }
            if (value >= this.getShapeLength()) {
                return max;
            }
        }
        double minLog = min > 0.0 ? Math.log10(min) : 0.0;
        double maxLog = max > 0.0 ? Math.log10(max) : 1.0;
        return Math.pow(10.0, value * (maxLog - minLog) / this.getShapeLength() + minLog);
    }

    @Override
    public List<Tick> getTicks(Axis axis) {
        LogarithmicRenderer2D.checkAxisBounds(axis);
        return super.getTicks(axis);
    }

    @Override
    protected void createTicks(List<Tick> ticks, Axis axis, double min, double max, Set<Double> tickPositions, boolean isAutoSpacing) {
        double tickSpacingMinor;
        double tickSpacing = 1.0;
        tickSpacing = isAutoSpacing ? 1.0 : this.getTickSpacing().doubleValue();
        int ticksMinorCount = this.getMinorTicksCount();
        double d = tickSpacingMinor = ticksMinorCount > 0 ? tickSpacing / (double)(ticksMinorCount + 1) : tickSpacing;
        if (min == 0.0) {
            min = 1.0;
        }
        double BASE = 10.0;
        double powerMin = MathUtils.magnitude(10.0, min);
        double powerMax = MathUtils.magnitude(10.0, max);
        double minTickMajor = MathUtils.ceil(min, powerMin * tickSpacing);
        int ticksPerPower = (int)Math.floor(10.0 / tickSpacingMinor);
        int initialTicksMinor = (int)Math.floor((minTickMajor - min) / (powerMin * tickSpacingMinor));
        int i = 0;
        block0: for (double power = powerMin; power <= powerMax; power *= 10.0) {
            double multipliedTickSpacingMinor = power * tickSpacingMinor;
            double minTick = MathUtils.ceil(power, multipliedTickSpacingMinor);
            for (int pi = 0; pi < ticksPerPower; ++pi) {
                double tickPositionWorld = minTick + (double)pi * multipliedTickSpacingMinor;
                if (tickPositionWorld < min) continue;
                if (tickPositionWorld > max) continue block0;
                Tick.TickType tickType = Tick.TickType.MINOR;
                if ((i++ - initialTicksMinor) % (ticksMinorCount + 1) == 0) {
                    tickType = Tick.TickType.MAJOR;
                }
                Tick tick = this.getTick(tickType, axis, tickPositionWorld);
                if (tick.position == null || tickPositions.contains(tickPositionWorld)) continue;
                ticks.add(tick);
                tickPositions.add(tickPositionWorld);
            }
        }
    }

    private static void checkAxisBounds(Axis axis) {
        if (axis.getMin().doubleValue() < 0.0 || axis.getMax().doubleValue() < 0.0) {
            throw new IllegalStateException("Axis bounds must be greater than or equal to zero for logarithmic axes.");
        }
    }
}

