/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.axes;

import de.erichseifert.gral.plots.axes.AbstractAxisRenderer2D;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.util.MathUtils;
import java.util.List;
import java.util.Set;

public class LinearRenderer2D
extends AbstractAxisRenderer2D {
    private static final long serialVersionUID = -1257582880797196423L;

    @Override
    public double worldToView(Axis axis, Number value, boolean extrapolate) {
        double min = axis.getMin().doubleValue();
        double max = axis.getMax().doubleValue();
        double val = value.doubleValue();
        if (!extrapolate) {
            if (val <= min) {
                return 0.0;
            }
            if (val >= max) {
                return this.getShapeLength();
            }
        }
        return (val - min) / (max - min) * this.getShapeLength();
    }

    @Override
    public Number viewToWorld(Axis axis, double value, boolean extrapolate) {
        double min = axis.getMin().doubleValue();
        double max = axis.getMax().doubleValue();
        if (!extrapolate) {
            if (value <= 0.0) {
                return min;
            }
            if (value >= this.getShapeLength()) {
                return max;
            }
        }
        return value / this.getShapeLength() * (max - min) + min;
    }

    @Override
    protected void createTicks(List<Tick> ticks, Axis axis, double min, double max, Set<Double> tickPositions, boolean isAutoSpacing) {
        double tickSpacing = 1.0;
        int ticksMinorCount = 3;
        if (isAutoSpacing) {
            double range = max - min;
            tickSpacing = MathUtils.magnitude(10.0, range / 4.0);
            if (range / tickSpacing > 8.0) {
                tickSpacing *= 2.0;
                ticksMinorCount = 1;
            }
            if (range / tickSpacing > 8.0) {
                tickSpacing *= 2.5;
                ticksMinorCount = 4;
            }
        } else {
            tickSpacing = this.getTickSpacing().doubleValue();
            ticksMinorCount = this.getMinorTicksCount();
        }
        double tickSpacingMinor = tickSpacing;
        if (ticksMinorCount > 0) {
            tickSpacingMinor = tickSpacing / (double)(ticksMinorCount + 1);
        }
        double minTickMajor = MathUtils.ceil(min, tickSpacing);
        double minTickMinor = MathUtils.ceil(min, tickSpacingMinor);
        int ticksTotal = (int)Math.ceil((max - min) / tickSpacingMinor);
        int initialTicksMinor = (int)((minTickMajor - min) / tickSpacingMinor);
        for (int tickCur = 0; tickCur < ticksTotal; ++tickCur) {
            double tickPositionWorld = minTickMinor + (double)tickCur * tickSpacingMinor;
            if (tickPositions.contains(tickPositionWorld)) continue;
            Tick.TickType tickType = Tick.TickType.MINOR;
            if ((tickCur - initialTicksMinor) % (ticksMinorCount + 1) == 0) {
                tickType = Tick.TickType.MAJOR;
            }
            Tick tick = this.getTick(tickType, axis, tickPositionWorld);
            if (tick.position == null) continue;
            ticks.add(tick);
            tickPositions.add(tickPositionWorld);
        }
    }
}

