/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.areas;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.areas.AbstractAreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class DefaultAreaRenderer2D
extends AbstractAreaRenderer {
    private static final long serialVersionUID = -202003022764142849L;

    @Override
    public Drawable getArea(List<DataPoint> points, final Shape shape) {
        return new AbstractDrawable(){
            private static final long serialVersionUID = -3659798228877496727L;

            @Override
            public void draw(DrawingContext context) {
                Paint paint = DefaultAreaRenderer2D.this.getColor();
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
            }
        };
    }

    @Override
    public Shape getAreaShape(List<DataPoint> points) {
        if (points.isEmpty() || points.get(0) == null) {
            return null;
        }
        Axis axisY = points.get((int)0).data.axes.get(1);
        AxisRenderer axisRendererY = points.get((int)0).data.axisRenderers.get(1);
        double axisYMin = axisY.getMin().doubleValue();
        double axisYMax = axisY.getMax().doubleValue();
        double axisYOrigin = MathUtils.limit(0.0, axisYMin, axisYMax);
        PointND<Double> posOrigin = null;
        if (axisRendererY != null) {
            posOrigin = axisRendererY.getPosition(axisY, axisYOrigin, true, false);
        }
        Path2D.Double shape = new Path2D.Double();
        if (posOrigin == null) {
            return shape;
        }
        double posYOrigin = posOrigin.get(1);
        double x = 0.0;
        double y = 0.0;
        for (DataPoint p : points) {
            Point2D pos = p.position.getPoint2D();
            x = pos.getX();
            y = pos.getY();
            if (shape.getCurrentPoint() == null) {
                ((Path2D)shape).moveTo(x, posYOrigin);
            }
            ((Path2D)shape).lineTo(x, y);
        }
        if (shape.getCurrentPoint() != null) {
            ((Path2D)shape).lineTo(x, posYOrigin);
            shape.closePath();
        }
        return shape;
    }
}

