/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DummyData;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.navigation.Navigable;
import de.erichseifert.gral.navigation.NavigationDirection;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.plots.AbstractPlot;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.PlotArea;
import de.erichseifert.gral.plots.PlotNavigator;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisListener;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.SeriesLegend;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XYPlot
extends AbstractPlot
implements Navigable,
AxisListener {
    private static final long serialVersionUID = 4501074701747572783L;
    public static final String AXIS_X = "x";
    public static final String AXIS_X2 = "x2";
    public static final String AXIS_Y = "y";
    public static final String AXIS_Y2 = "y2";
    private final Map<DataSource, List<PointRenderer>> pointRenderersByDataSource;
    private final Map<DataSource, List<LineRenderer>> lineRenderersByDataSource;
    private final Map<DataSource, List<AreaRenderer>> areaRenderersByDataSource;
    private transient XYPlotNavigator navigator;
    private transient boolean navigatorInitialized;

    public XYPlot(DataSource ... data) {
        super(new DataSource[0]);
        this.pointRenderersByDataSource = new HashMap<DataSource, List<PointRenderer>>(data.length);
        this.lineRenderersByDataSource = new HashMap<DataSource, List<LineRenderer>>(data.length);
        this.areaRenderersByDataSource = new HashMap<DataSource, List<AreaRenderer>>(data.length);
        this.setPlotArea(new XYPlotArea2D(this));
        this.setLegend(new XYLegend(this));
        for (DataSource source : data) {
            this.add(source);
        }
        this.createDefaultAxes();
        this.autoscaleAxes();
        this.createDefaultAxisRenderers();
        for (String axisName : this.getAxesNames()) {
            this.getAxis(axisName).addAxisListener(this);
        }
    }

    @Override
    protected void createDefaultAxes() {
        Axis axisX = new Axis();
        Axis axisY = new Axis();
        this.setAxis(AXIS_X, axisX);
        this.setAxis(AXIS_Y, axisY);
    }

    @Override
    protected void createDefaultAxisRenderers() {
        LinearRenderer2D axisXRenderer = new LinearRenderer2D();
        LinearRenderer2D axisYRenderer = new LinearRenderer2D();
        this.setAxisRenderer(AXIS_X, axisXRenderer);
        this.setAxisRenderer(AXIS_Y, axisYRenderer);
    }

    @Override
    protected void layoutAxes() {
        if (this.getPlotArea() == null) {
            return;
        }
        this.layoutAxisShape(AXIS_X, Orientation.HORIZONTAL);
        this.layoutAxisShape(AXIS_X2, Orientation.HORIZONTAL);
        this.layoutAxisShape(AXIS_Y, Orientation.VERTICAL);
        this.layoutAxisShape(AXIS_Y2, Orientation.VERTICAL);
        this.layoutAxisComponent(AXIS_X, Orientation.HORIZONTAL);
        this.layoutAxisComponent(AXIS_X2, Orientation.HORIZONTAL);
        this.layoutAxisComponent(AXIS_Y, Orientation.VERTICAL);
        this.layoutAxisComponent(AXIS_Y2, Orientation.VERTICAL);
    }

    private void layoutAxisShape(String axisName, Orientation orientation) {
        Rectangle2D plotBounds = this.getPlotArea().getBounds();
        Drawable comp = this.getAxisComponent(axisName);
        AxisRenderer renderer = this.getAxisRenderer(axisName);
        if (comp == null || renderer == null) {
            return;
        }
        Dimension2D size = comp.getPreferredSize();
        Line2D.Double shape = orientation == Orientation.HORIZONTAL ? new Line2D.Double(0.0, 0.0, plotBounds.getWidth(), 0.0) : new Line2D.Double(size.getWidth(), plotBounds.getHeight(), size.getWidth(), 0.0);
        renderer.setShape(shape);
    }

    private void layoutAxisComponent(String axisName, Orientation orientation) {
        Drawable comp = this.getAxisComponent(axisName);
        AxisRenderer renderer = this.getAxisRenderer(axisName);
        if (comp == null || renderer == null) {
            return;
        }
        String nameSecondary = orientation == Orientation.HORIZONTAL ? AXIS_Y : AXIS_X;
        Axis axisSecondary = this.getAxis(nameSecondary);
        AxisRenderer rendererSecondary = this.getAxisRenderer(nameSecondary);
        if (axisSecondary == null || !axisSecondary.isValid() || rendererSecondary == null) {
            return;
        }
        Number intersection = renderer.getIntersection();
        PointND pos = rendererSecondary.getPosition(axisSecondary, intersection, false, false);
        if (pos == null) {
            pos = new PointND((Number[])new Double[]{0.0, 0.0});
        }
        Rectangle2D plotBounds = this.getPlotArea().getBounds();
        Dimension2D size = comp.getPreferredSize();
        if (orientation == Orientation.HORIZONTAL) {
            comp.setBounds(plotBounds.getMinX(), (Double)pos.get(1) + plotBounds.getMinY(), plotBounds.getWidth(), size.getHeight());
        } else {
            comp.setBounds(plotBounds.getMinX() - size.getWidth() + (Double)pos.get(0), plotBounds.getMinY(), size.getWidth(), plotBounds.getHeight());
        }
    }

    public List<PointRenderer> getPointRenderers(DataSource s) {
        List<PointRenderer> pointRenderers = this.pointRenderersByDataSource.get(s);
        if (pointRenderers != null) {
            return Collections.unmodifiableList(pointRenderers);
        }
        return Collections.emptyList();
    }

    public void addPointRenderer(DataSource s, PointRenderer pointRenderer) {
        List<PointRenderer> pointRenderers = this.pointRenderersByDataSource.get(s);
        if (pointRenderers == null) {
            pointRenderers = new ArrayList<PointRenderer>();
            this.pointRenderersByDataSource.put(s, pointRenderers);
        }
        pointRenderers.add(pointRenderer);
    }

    public void removePointRenderer(DataSource s, PointRenderer pointRenderer) {
        List<PointRenderer> pointRenderers = this.pointRenderersByDataSource.get(s);
        if (pointRenderers != null) {
            pointRenderers.remove(pointRenderer);
        }
    }

    public void setPointRenderers(DataSource s, List<PointRenderer> pointRenderers) {
        this.pointRenderersByDataSource.put(s, pointRenderers);
    }

    public void setPointRenderers(DataSource s, PointRenderer pointRendererFirst, PointRenderer ... pointRenderers) {
        ArrayList<PointRenderer> pointRendererList = null;
        if (pointRendererFirst == null) {
            this.setPointRenderers(s, pointRendererList);
            return;
        }
        pointRendererList = new ArrayList<PointRenderer>(pointRenderers.length + 1);
        pointRendererList.add(pointRendererFirst);
        for (PointRenderer pointRenderer : pointRenderers) {
            if (pointRenderer == null) {
                throw new IllegalArgumentException("A PointRenderer for a DataSource cannot be null.");
            }
            pointRendererList.add(pointRenderer);
        }
        this.setPointRenderers(s, pointRendererList);
    }

    public List<LineRenderer> getLineRenderers(DataSource s) {
        List<LineRenderer> lineRenderers = this.lineRenderersByDataSource.get(s);
        if (lineRenderers != null) {
            return Collections.unmodifiableList(lineRenderers);
        }
        return Collections.emptyList();
    }

    public void setLineRenderers(DataSource s, List<LineRenderer> lineRenderers) {
        this.lineRenderersByDataSource.put(s, lineRenderers);
    }

    public void setLineRenderers(DataSource s, LineRenderer lineRendererFirst, LineRenderer ... lineRenderers) {
        ArrayList<LineRenderer> lineRendererList = null;
        if (lineRendererFirst == null) {
            this.setLineRenderers(s, lineRendererList);
            return;
        }
        lineRendererList = new ArrayList<LineRenderer>(lineRenderers.length + 1);
        lineRendererList.add(lineRendererFirst);
        for (LineRenderer lineRenderer : lineRenderers) {
            if (lineRenderer == null) {
                throw new IllegalArgumentException("A LineRenderer for a DataSource cannot be null.");
            }
            lineRendererList.add(lineRenderer);
        }
        this.setLineRenderers(s, lineRendererList);
    }

    public List<AreaRenderer> getAreaRenderers(DataSource s) {
        List<AreaRenderer> areaRenderers = this.areaRenderersByDataSource.get(s);
        if (areaRenderers != null) {
            return Collections.unmodifiableList(areaRenderers);
        }
        return Collections.emptyList();
    }

    public void setAreaRenderers(DataSource s, List<AreaRenderer> areaRenderers) {
        this.areaRenderersByDataSource.put(s, areaRenderers);
    }

    public void setAreaRenderers(DataSource s, AreaRenderer areaRendererFirst, AreaRenderer ... areaRenderers) {
        ArrayList<AreaRenderer> areaRendererList = null;
        if (areaRendererFirst == null) {
            this.setAreaRenderers(s, areaRendererList);
            return;
        }
        areaRendererList = new ArrayList<AreaRenderer>(areaRenderers.length + 1);
        areaRendererList.add(areaRendererFirst);
        for (AreaRenderer areaRenderer : areaRenderers) {
            if (areaRenderer == null) {
                throw new IllegalArgumentException("An AreaRenderer for a DataSource cannot be null.");
            }
            areaRendererList.add(areaRenderer);
        }
        this.setAreaRenderers(s, areaRendererList);
    }

    @Override
    public void setAxisRenderer(String axisName, AxisRenderer renderer) {
        if (renderer != null) {
            if (AXIS_X2.equals(axisName) || AXIS_Y.equals(axisName)) {
                renderer.setShapeNormalOrientationClockwise(true);
            }
            if (AXIS_Y.equals(axisName)) {
                renderer.getLabel().setRotation(90.0);
            }
        }
        super.setAxisRenderer(axisName, renderer);
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        super.add(index, source, visible);
        this.setMapping(source, AXIS_X, AXIS_Y);
        this.autoscaleAxes();
        DefaultPointRenderer2D pointRendererDefault = new DefaultPointRenderer2D();
        LineRenderer lineRendererDefault = null;
        AreaRenderer areaRendererDefault = null;
        this.setPointRenderers(source, pointRendererDefault, new PointRenderer[0]);
        this.setLineRenderers(source, lineRendererDefault, new LineRenderer[0]);
        this.setAreaRenderers(source, areaRendererDefault, new AreaRenderer[0]);
    }

    @Override
    public Navigator getNavigator() {
        if (this.navigator == null) {
            this.navigator = new XYPlotNavigator(this);
        }
        return this.navigator;
    }

    @Override
    public void draw(DrawingContext context) {
        super.draw(context);
        if (!this.navigatorInitialized) {
            this.getNavigator().setDefaultState();
            this.navigatorInitialized = true;
        }
    }

    @Override
    public void rangeChanged(Axis axis, Number min, Number max) {
        this.layoutAxes();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        for (String axisName : this.getAxesNames()) {
            this.getAxis(axisName).addAxisListener(this);
        }
    }

    private static class LegendSymbol
    extends AbstractLegend.AbstractSymbol {
        private static final DataSource DUMMY_DATA = new DummyData(2, Integer.MAX_VALUE, Double.valueOf(0.5));
        private final XYPlot plot;
        private final DataSource data;

        public LegendSymbol(XYPlot plot, DataSource data, Font font, Dimension2D symbolSize) {
            super(font, symbolSize);
            this.plot = plot;
            this.data = data;
        }

        @Override
        public void draw(DrawingContext context) {
            Row symbolRow = new Row(DUMMY_DATA, 0);
            Rectangle2D bounds = this.getBounds();
            Axis axisX = new Axis(0.0, 1.0);
            LinearRenderer2D axisRendererX = new LinearRenderer2D();
            axisRendererX.setShape(new Line2D.Double(bounds.getMinX(), bounds.getCenterY(), bounds.getMaxX(), bounds.getCenterY()));
            Axis axisY = new Axis(0.0, 1.0);
            LinearRenderer2D axisRendererY = new LinearRenderer2D();
            axisRendererY.setShape(new Line2D.Double(bounds.getCenterX(), bounds.getMaxY(), bounds.getCenterX(), bounds.getMinY()));
            PointData pointData = new PointData(Arrays.asList(axisX, axisY), Arrays.asList(axisRendererX, axisRendererY), symbolRow, symbolRow.getIndex(), 0);
            DataPoint p1 = new DataPoint(pointData, new PointND((Number[])new Double[]{bounds.getMinX(), bounds.getCenterY()}));
            DataPoint p2 = new DataPoint(pointData, new PointND((Number[])new Double[]{bounds.getCenterX(), bounds.getCenterY()}));
            DataPoint p3 = new DataPoint(pointData, new PointND((Number[])new Double[]{bounds.getMaxX(), bounds.getCenterY()}));
            List<DataPoint> points = Arrays.asList(p1, p2, p3);
            AreaRenderer areaRenderer = null;
            List<AreaRenderer> areaRenderers = this.plot.getAreaRenderers(this.data);
            if (!areaRenderers.isEmpty()) {
                areaRenderer = areaRenderers.get(0);
            }
            if (areaRenderer != null) {
                Shape area = areaRenderer.getAreaShape(points);
                Drawable drawable = areaRenderer.getArea(points, area);
                drawable.draw(context);
            }
            LineRenderer lineRenderer = null;
            List<LineRenderer> lineRenderers = this.plot.getLineRenderers(this.data);
            if (!lineRenderers.isEmpty()) {
                lineRenderer = lineRenderers.get(0);
            }
            if (lineRenderer != null) {
                Shape line = lineRenderer.getLineShape(points);
                Drawable drawable = lineRenderer.getLine(points, line);
                drawable.draw(context);
            }
            PointRenderer pointRenderer = null;
            List<PointRenderer> pointRenderers = this.plot.getPointRenderers(this.data);
            if (!pointRenderers.isEmpty()) {
                pointRenderer = pointRenderers.get(0);
            }
            if (pointRenderer != null) {
                Graphics2D graphics = context.getGraphics();
                Point2D pos = p2.position.getPoint2D();
                AffineTransform txOrig = graphics.getTransform();
                graphics.translate(pos.getX(), pos.getY());
                Shape shape = pointRenderer.getPointShape(pointData);
                Drawable drawable = pointRenderer.getPoint(pointData, shape);
                drawable.draw(context);
                graphics.setTransform(txOrig);
            }
        }
    }

    public static class XYLegend
    extends SeriesLegend {
        private static final long serialVersionUID = -4629928754001372002L;
        private final XYPlot plot;

        public XYLegend(XYPlot plot) {
            this.plot = plot;
        }

        @Override
        protected Drawable getSymbol(DataSource data) {
            return new LegendSymbol(this.plot, data, this.plot.getFont(), this.plot.getLegend().getSymbolSize());
        }
    }

    public static class XYPlotArea2D
    extends PlotArea {
        private static final long serialVersionUID = -3673157774425536428L;
        private final XYPlot plot;
        private boolean majorGridX;
        private boolean majorGridY;
        private Paint majorGridColor;
        private boolean minorGridX;
        private boolean minorGridY;
        private Paint minorGridColor;

        public XYPlotArea2D(XYPlot plot) {
            this.plot = plot;
            this.majorGridX = true;
            this.majorGridY = true;
            this.majorGridColor = new Color(0.0f, 0.0f, 0.0f, 0.1f);
            this.minorGridX = false;
            this.minorGridY = false;
            this.minorGridColor = new Color(0.0f, 0.0f, 0.0f, 0.05f);
        }

        @Override
        public void draw(DrawingContext context) {
            this.drawBackground(context);
            this.drawGrid(context);
            this.drawBorder(context);
            this.drawPlot(context);
            this.plot.drawAxes(context);
            this.plot.drawLegend(context);
        }

        protected void drawGrid(DrawingContext context) {
            Graphics2D graphics = context.getGraphics();
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(this.getX(), this.getY());
            AffineTransform txOffset = graphics.getTransform();
            Rectangle2D bounds = this.getBounds();
            if (this.isMajorGridX() || this.isMinorGridX()) {
                AxisRenderer axisXRenderer = this.plot.getAxisRenderer(XYPlot.AXIS_X);
                Axis axisX = this.plot.getAxis(XYPlot.AXIS_X);
                if (axisXRenderer != null && axisX != null && axisX.isValid()) {
                    Shape shapeX = axisXRenderer.getShape();
                    Rectangle2D shapeBoundsX = shapeX.getBounds2D();
                    List<Tick> ticksX = axisXRenderer.getTicks(axisX);
                    Line2D.Double gridLineVert = new Line2D.Double(-shapeBoundsX.getMinX(), -shapeBoundsX.getMinY(), -shapeBoundsX.getMinX(), bounds.getHeight() - shapeBoundsX.getMinY());
                    for (Tick tick : ticksX) {
                        Point2D tickPoint;
                        if (tick.type == Tick.TickType.MAJOR && !this.isMajorGridX() || tick.type == Tick.TickType.MINOR && !this.isMinorGridX() || (tickPoint = tick.position.getPoint2D()) == null) continue;
                        Paint paint = this.majorGridColor;
                        if (tick.type == Tick.TickType.MINOR) {
                            paint = this.getMinorGridColor();
                        }
                        graphics.translate(tickPoint.getX(), tickPoint.getY());
                        GraphicsUtils.drawPaintedShape(graphics, gridLineVert, paint, null, null);
                        graphics.setTransform(txOffset);
                    }
                }
            }
            if (this.isMajorGridY() || this.isMinorGridY()) {
                Axis axisY = this.plot.getAxis(XYPlot.AXIS_Y);
                AxisRenderer axisYRenderer = this.plot.getAxisRenderer(XYPlot.AXIS_Y);
                if (axisY != null && axisY.isValid() && axisYRenderer != null) {
                    Shape shapeY = axisYRenderer.getShape();
                    Rectangle2D shapeBoundsY = shapeY.getBounds2D();
                    List<Tick> ticksY = axisYRenderer.getTicks(axisY);
                    Line2D.Double gridLineHoriz = new Line2D.Double(-shapeBoundsY.getMinX(), -shapeBoundsY.getMinY(), bounds.getWidth() - shapeBoundsY.getMinX(), -shapeBoundsY.getMinY());
                    for (Tick tick : ticksY) {
                        Point2D tickPoint;
                        boolean isMinorTick;
                        boolean isMajorTick = tick.type == Tick.TickType.MAJOR;
                        boolean bl = isMinorTick = tick.type == Tick.TickType.MINOR;
                        if (isMajorTick && !this.isMajorGridY() || isMinorTick && !this.isMinorGridY() || (tickPoint = tick.position.getPoint2D()) == null) continue;
                        Paint paint = this.majorGridColor;
                        if (isMinorTick) {
                            paint = this.getMinorGridColor();
                        }
                        graphics.translate(tickPoint.getX(), tickPoint.getY());
                        GraphicsUtils.drawPaintedShape(graphics, gridLineHoriz, paint, null, null);
                        graphics.setTransform(txOffset);
                    }
                }
            }
            graphics.setTransform(txOrig);
        }

        @Override
        protected void drawPlot(DrawingContext context) {
            Graphics2D graphics = context.getGraphics();
            Shape clipBoundsOld = graphics.getClip();
            Insets2D clipOffset = this.getClippingOffset();
            if (clipOffset != null) {
                double fontSize = this.getBaseFont().getSize2D();
                Shape clipBounds = new Rectangle2D.Double(this.getX() + clipOffset.getLeft() * fontSize, this.getY() + clipOffset.getTop() * fontSize, this.getWidth() - clipOffset.getHorizontal() * fontSize, this.getHeight() - clipOffset.getVertical() * fontSize);
                if (clipBoundsOld != null) {
                    Area clipBoundsNew = new Area(clipBoundsOld);
                    clipBoundsNew.intersect(new Area(clipBounds));
                    clipBounds = clipBoundsNew;
                }
                graphics.setClip(clipBounds);
            }
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(this.getX(), this.getY());
            AffineTransform txOffset = graphics.getTransform();
            for (DataSource s : this.plot.getVisibleData()) {
                Shape pointShape;
                PointND<Double> pos;
                int colY;
                int colX;
                if (s.getColumnCount() == 0 || (colX = 0) < 0 || colX >= s.getColumnCount() || !s.isColumnNumeric(colX) || (colY = 1) < 0 || colY >= s.getColumnCount() || !s.isColumnNumeric(colY)) continue;
                String[] axisNames = this.plot.getMapping(s);
                Axis axisX = this.plot.getAxis(axisNames[0]);
                Axis axisY = this.plot.getAxis(axisNames[1]);
                if (!axisX.isValid() || !axisY.isValid()) continue;
                AxisRenderer axisXRenderer = this.plot.getAxisRenderer(axisNames[0]);
                AxisRenderer axisYRenderer = this.plot.getAxisRenderer(axisNames[1]);
                LinkedList<DataPoint> points = new LinkedList<DataPoint>();
                for (int i = 0; i < s.getRowCount(); ++i) {
                    PointND axisPosY;
                    Row row = new Row(s, i);
                    Number valueX = (Number)((Object)row.get(colX));
                    Number valueY = (Number)((Object)row.get(colY));
                    PointND axisPosX = axisXRenderer != null ? axisXRenderer.getPosition(axisX, valueX, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    PointND pointND = axisPosY = axisYRenderer != null ? axisYRenderer.getPosition(axisY, valueY, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    if (axisPosX == null || axisPosY == null) continue;
                    PointND pos2 = new PointND((Number[])new Double[]{(Double)axisPosX.get(0), (Double)axisPosY.get(1)});
                    PointData pointData = new PointData(Arrays.asList(axisX, axisY), Arrays.asList(axisXRenderer, axisYRenderer), row, row.getIndex(), colY);
                    DataPoint dataPoint = new DataPoint(pointData, pos2);
                    points.add(dataPoint);
                }
                ArrayList<PointRenderer> pointRenderers = new ArrayList<PointRenderer>(this.plot.getPointRenderers(s));
                Collections.reverse(pointRenderers);
                ArrayList<AreaRenderer> areaRenderers = new ArrayList<AreaRenderer>(this.plot.getAreaRenderers(s));
                Collections.reverse(areaRenderers);
                for (AreaRenderer areaRenderer : areaRenderers) {
                    Shape area;
                    Shape punchedArea = area = areaRenderer.getAreaShape(points);
                    for (PointRenderer pointRenderer : pointRenderers) {
                        ArrayList<Shape> punchShapes = new ArrayList<Shape>(points.size());
                        for (DataPoint point : points) {
                            Shape punchShape = pointRenderer.getPointShape(point.data);
                            punchShapes.add(punchShape);
                        }
                        punchedArea = XYPlotArea2D.punch(punchedArea, points, punchShapes, areaRenderer.getGap(), areaRenderer.isGapRounded());
                    }
                    Drawable drawable = areaRenderer.getArea(points, punchedArea);
                    drawable.draw(context);
                }
                ArrayList<LineRenderer> lineRenderers = new ArrayList<LineRenderer>(this.plot.getLineRenderers(s));
                Collections.reverse(lineRenderers);
                for (LineRenderer lineRenderer : lineRenderers) {
                    Shape line;
                    Shape punchedLine = line = lineRenderer.getLineShape(points);
                    for (PointRenderer pointRenderer2 : pointRenderers) {
                        ArrayList<Shape> punchShapes = new ArrayList<Shape>(points.size());
                        for (DataPoint point : points) {
                            Shape punchShape = pointRenderer2.getPointShape(point.data);
                            punchShapes.add(punchShape);
                        }
                        punchedLine = XYPlotArea2D.punch(punchedLine, points, punchShapes, lineRenderer.getGap(), lineRenderer.isGapRounded());
                    }
                    Drawable drawable = lineRenderer.getLine(points, punchedLine);
                    drawable.draw(context);
                }
                if (this.plot.getPointRenderers(s).isEmpty()) continue;
                for (DataPoint point : points) {
                    pos = point.position;
                    double pointX = pos.get(0);
                    double pointY = pos.get(1);
                    graphics.translate(pointX, pointY);
                    for (PointRenderer pointRenderer : this.plot.getPointRenderers(s)) {
                        pointShape = pointRenderer.getPointShape(point.data);
                        Drawable pointDrawable = pointRenderer.getPoint(point.data, pointShape);
                        pointDrawable.draw(context);
                    }
                    graphics.setTransform(txOffset);
                }
                for (DataPoint point : points) {
                    pos = point.position;
                    double pointX = pos.get(0);
                    double pointY = pos.get(1);
                    graphics.translate(pointX, pointY);
                    for (PointRenderer pointRenderer : this.plot.getPointRenderers(s)) {
                        pointShape = pointRenderer.getPointShape(point.data);
                        Drawable labelDrawable = pointRenderer.getValue(point.data, pointShape);
                        labelDrawable.draw(context);
                    }
                    graphics.setTransform(txOffset);
                }
            }
            graphics.setTransform(txOrig);
            if (clipOffset != null) {
                graphics.setClip(clipBoundsOld);
            }
        }

        protected static Shape punch(Shape shape, List<DataPoint> dataPoints, List<Shape> punchShapes, double gap, boolean roundedGaps) {
            if (!MathUtils.isCalculatable(gap) || gap == 0.0) {
                return shape;
            }
            Area punched = new Area(shape);
            for (int pointIndex = 0; pointIndex < dataPoints.size(); ++pointIndex) {
                DataPoint p = dataPoints.get(pointIndex);
                punched = GeometryUtils.punch(punched, gap, roundedGaps, p.position.getPoint2D(), punchShapes.get(pointIndex));
            }
            return punched;
        }

        public boolean isMajorGridX() {
            return this.majorGridX;
        }

        public void setMajorGridX(boolean gridMajorX) {
            this.majorGridX = gridMajorX;
        }

        public boolean isMajorGridY() {
            return this.majorGridY;
        }

        public void setMajorGridY(boolean gridMajorY) {
            this.majorGridY = gridMajorY;
        }

        public Paint getMajorGridColor() {
            return this.majorGridColor;
        }

        public void setMajorGridColor(Color color) {
            this.majorGridColor = color;
        }

        public boolean isMinorGridX() {
            return this.minorGridX;
        }

        public void setMinorGridX(boolean gridMinorX) {
            this.minorGridX = gridMinorX;
        }

        public boolean isMinorGridY() {
            return this.minorGridY;
        }

        public void setMinorGridY(boolean gridMinorY) {
            this.minorGridY = gridMinorY;
        }

        public Paint getMinorGridColor() {
            return this.minorGridColor;
        }

        public void setMinorGridColor(Color color) {
            this.minorGridColor = color;
        }
    }

    public static class XYPlotNavigator
    extends PlotNavigator {
        public XYPlotNavigator(XYPlot plot) {
            super((Plot)plot, XYNavigationDirection.ARBITRARY.getAxesNames());
        }

        @Override
        public void setDirection(NavigationDirection direction) {
            if (direction == this.getDirection()) {
                return;
            }
            if (!(direction instanceof XYNavigationDirection)) {
                throw new IllegalArgumentException("Unknown direction.");
            }
            String[] axesNames = ((XYNavigationDirection)direction).getAxesNames();
            this.setAxes(axesNames);
            super.setDirection(direction);
        }

        @Override
        protected Number getDimensionValue(String axisName, PointND<? extends Number> values) {
            if (XYPlot.AXIS_Y.equals(axisName) || XYPlot.AXIS_Y2.equals(axisName)) {
                return -values.get(1).doubleValue();
            }
            return values.get(0);
        }

        @Override
        protected int getDimensions() {
            return 2;
        }
    }

    public static enum XYNavigationDirection implements NavigationDirection
    {
        HORIZONTAL("x", "x2"),
        VERTICAL("y", "y2"),
        ARBITRARY("x", "y", "x2", "y2");

        private final String[] axesNames;

        private XYNavigationDirection(String ... axesNames) {
            this.axesNames = axesNames;
        }

        public String[] getAxesNames() {
            return this.axesNames;
        }
    }
}

