/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.navigation.AbstractNavigator;
import de.erichseifert.gral.navigation.NavigationEvent;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class PlotNavigator
extends AbstractNavigator {
    private final Plot plot;
    private final Map<String, NavigationInfo> infos;
    private final List<String> axes = new LinkedList<String>();

    public PlotNavigator(Plot plot, List<String> axesNames) {
        this.infos = new HashMap<String, NavigationInfo>();
        this.plot = plot;
        this.setAxes(axesNames);
    }

    public PlotNavigator(Plot plot, String ... axesNames) {
        this(plot, Arrays.asList(axesNames));
    }

    private void refresh() {
        for (String axisName : this.getAxes()) {
            AxisRenderer renderer;
            NavigationInfo info = this.getInfo(axisName);
            if (info == null || (renderer = this.getPlot().getAxisRenderer(axisName)) == null) continue;
            Axis axis = this.getPlot().getAxis(axisName);
            double minOrig = renderer.worldToView(axis, info.getMinOriginal(), true);
            double maxOrig = renderer.worldToView(axis, info.getMaxOriginal(), true);
            double rangeOrig = maxOrig - minOrig;
            double zoom = info.getZoom();
            double range = rangeOrig / zoom;
            double center = renderer.worldToView(axis, info.getCenter(), true);
            Number min = renderer.viewToWorld(axis, center - 0.5 * range, true);
            Number max = renderer.viewToWorld(axis, center + 0.5 * range, true);
            axis.setRange(min, max);
        }
    }

    protected Plot getPlot() {
        return this.plot;
    }

    @Override
    public double getZoom() {
        double zoom = 0.0;
        int count = 0;
        for (String axisName : this.getAxes()) {
            NavigationInfo info = this.getInfo(axisName);
            if (info == null || !MathUtils.isCalculatable(info.getZoom())) continue;
            zoom += info.getZoom();
            ++count;
        }
        return zoom / (double)count;
    }

    @Override
    public void setZoom(double zoomNew) {
        if (!this.isZoomable() || zoomNew <= 0.0 || !MathUtils.isCalculatable(zoomNew)) {
            return;
        }
        double zoomOld = this.getZoom();
        if (zoomOld == (zoomNew = MathUtils.limit(zoomNew, this.getZoomMin(), this.getZoomMax()))) {
            return;
        }
        for (String axisName : this.getAxes()) {
            NavigationInfo info = this.getInfo(axisName);
            if (info == null) continue;
            info.setZoom(zoomNew);
        }
        NavigationEvent<Double> event = new NavigationEvent<Double>(this, zoomOld, zoomNew);
        this.fireZoomChanged(event);
        this.refresh();
    }

    @Override
    public PointND<? extends Number> getCenter() {
        List<String> axesNames = this.getAxes();
        Number[] centerCoords = new Double[axesNames.size()];
        int axisIndex = 0;
        for (String axisName : axesNames) {
            NavigationInfo info = this.getInfo(axisName);
            if (info != null) {
                double axisCenter = info.getCenter();
                centerCoords[axisIndex] = axisCenter;
            }
            ++axisIndex;
        }
        return new PointND(centerCoords);
    }

    @Override
    public void setCenter(PointND<? extends Number> center) {
        if (!this.isPannable()) {
            return;
        }
        PointND<? extends Number> centerOld = this.getCenter();
        if (centerOld.equals(center)) {
            return;
        }
        List<String> axesNames = this.getAxes();
        int axisIndex = 0;
        for (String axisName : axesNames) {
            NavigationInfo info = this.getInfo(axisName);
            if (info != null) {
                Number centerCoordNew = center.get(axisIndex);
                info.setCenter(centerCoordNew.doubleValue());
            }
            ++axisIndex;
        }
        NavigationEvent<PointND<? extends Number>> event = new NavigationEvent<PointND<? extends Number>>(this, centerOld, center);
        this.fireCenterChanged(event);
        this.refresh();
    }

    @Override
    public void pan(PointND<? extends Number> deltas) {
        if (!this.isPannable()) {
            return;
        }
        PointND<? extends Number> centerOld = this.getCenter();
        Number[] centerCoords = new Double[centerOld.getDimensions()];
        int axisIndex = 0;
        for (String axisName : this.getAxes()) {
            NavigationInfo info = this.getInfo(axisName);
            if (info != null) {
                double delta = this.getDimensionValue(axisName, deltas).doubleValue();
                AxisRenderer renderer = this.getPlot().getAxisRenderer(axisName);
                if (renderer != null) {
                    boolean swapped = renderer.isShapeDirectionSwapped();
                    if (swapped) {
                        delta = -delta;
                    }
                    Axis axis = this.getPlot().getAxis(axisName);
                    double center = renderer.worldToView(axis, info.getCenter(), true);
                    Number centerNew = renderer.viewToWorld(axis, center - delta, true);
                    info.setCenter(centerNew.doubleValue());
                    centerCoords[axisIndex] = centerNew.doubleValue();
                }
            }
            ++axisIndex;
        }
        PointND centerNew = new PointND(centerCoords);
        NavigationEvent<PointND<? extends Number>> event = new NavigationEvent<PointND<? extends Number>>(this, centerOld, centerNew);
        this.fireCenterChanged(event);
        this.refresh();
    }

    @Override
    public void setDefaultState() {
        this.infos.clear();
        for (String axisName : this.getAxes()) {
            Axis axis = this.getPlot().getAxis(axisName);
            if (axis == null) continue;
            Number center = 0.0;
            AxisRenderer renderer = this.getPlot().getAxisRenderer(axisName);
            if (renderer != null && axis.isValid()) {
                double min = renderer.worldToView(axis, axis.getMin(), false);
                double max = renderer.worldToView(axis, axis.getMax(), false);
                if (MathUtils.isCalculatable(min) && MathUtils.isCalculatable(max)) {
                    center = renderer.viewToWorld(axis, (min + max) / 2.0, false);
                }
            }
            NavigationInfo info = new NavigationInfo(axis.getMin(), axis.getMax(), (double)center);
            this.infos.put(axisName, info);
        }
    }

    @Override
    public void reset() {
        double zoomOld = this.getZoom();
        double zoomNew = 1.0;
        PointND<? extends Number> centerOld = this.getCenter();
        List<String> axesNames = this.getAxes();
        Number[] centerCoordsOriginal = new Double[centerOld.getDimensions()];
        int axisIndex = 0;
        for (String axisName : axesNames) {
            NavigationInfo info = this.getInfo(axisName);
            if (info != null) {
                double centerCoordOriginal = info.getCenterOriginal();
                centerCoordsOriginal[axisIndex] = centerCoordOriginal;
                info.setCenter(centerCoordOriginal);
                info.setZoom(zoomNew);
            }
            ++axisIndex;
        }
        PointND centerNew = new PointND(centerCoordsOriginal);
        NavigationEvent<PointND<? extends Number>> panEvent = new NavigationEvent<PointND<? extends Number>>(this, centerOld, centerNew);
        this.fireCenterChanged(panEvent);
        NavigationEvent<Double> zoomEvent = new NavigationEvent<Double>(this, zoomOld, 1.0);
        this.fireZoomChanged(zoomEvent);
        this.refresh();
    }

    protected NavigationInfo getInfo(String axisName) {
        return this.infos.get(axisName);
    }

    protected List<String> getAxes() {
        return Collections.unmodifiableList(this.axes);
    }

    protected void setAxes(List<String> axesNames) {
        this.axes.clear();
        this.axes.addAll(axesNames);
        this.setDefaultState();
    }

    protected void setAxes(String ... axesNames) {
        this.setAxes(Arrays.asList(axesNames));
    }

    protected abstract int getDimensions();

    protected abstract Number getDimensionValue(String var1, PointND<? extends Number> var2);

    protected static final class NavigationInfo {
        private final Number minOriginal;
        private final Number maxOriginal;
        private final double centerOriginal;
        private double center;
        private double zoom;

        public NavigationInfo(Number min, Number max, double center) {
            this.minOriginal = min;
            this.maxOriginal = max;
            this.center = this.centerOriginal = center;
            this.zoom = 1.0;
        }

        public Number getMinOriginal() {
            return this.minOriginal;
        }

        public Number getMaxOriginal() {
            return this.maxOriginal;
        }

        public double getCenterOriginal() {
            return this.centerOriginal;
        }

        public double getCenter() {
            return this.center;
        }

        public void setCenter(double center) {
            this.center = center;
        }

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }
    }
}

