/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.filters.Accumulation;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.navigation.AbstractNavigator;
import de.erichseifert.gral.navigation.Navigable;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.plots.AbstractPlot;
import de.erichseifert.gral.plots.PlotArea;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ContinuousColorMapper;
import de.erichseifert.gral.plots.colors.QuasiRandomColors;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.ValueLegend;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PiePlot
extends AbstractPlot
implements Navigable {
    private static final long serialVersionUID = 5486418164040578150L;
    public static final String AXIS_TANGENTIAL = "tangential";
    private final Map<DataSource, PointRenderer> pointRenderers;
    private transient PiePlotNavigator navigator;
    private final Point2D center = new Point2D.Double(0.5, 0.5);
    private double radius = 1.0;
    private double start = 0.0;
    private boolean clockwise = true;

    public PiePlot(DataSource data) {
        super(new DataSource[0]);
        this.pointRenderers = new HashMap<DataSource, PointRenderer>();
        this.setPlotArea(new PiePlotArea2D(this));
        this.setLegend(new PiePlotLegend(this));
        this.add(data);
        this.createDefaultAxes();
        this.createDefaultAxisRenderers();
        this.dataUpdated(data, new DataChangeEvent[0]);
    }

    @Override
    protected void createDefaultAxes() {
        Axis axisPie = new Axis();
        this.setAxis(AXIS_TANGENTIAL, axisPie);
    }

    @Override
    public void autoscaleAxis(String axisName) {
        if (!AXIS_TANGENTIAL.equals(axisName)) {
            super.autoscaleAxis(axisName);
            return;
        }
        List<DataSource> sources = this.getVisibleData();
        if (sources.isEmpty()) {
            return;
        }
        DataSource data = sources.get(0);
        if (data.getRowCount() == 0) {
            return;
        }
        double sum = this.getSum(data);
        if (sum == 0.0) {
            return;
        }
        Axis axis = this.getAxis(axisName);
        if (axis == null || !axis.isAutoscaled()) {
            return;
        }
        axis.setRange(0.0, sum);
    }

    @Override
    protected void createDefaultAxisRenderers() {
        LinearRenderer2D renderer = new LinearRenderer2D();
        Ellipse2D.Double shape = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        renderer.setShape(shape);
        renderer.setShapeVisible(false);
        this.setAxisRenderer(AXIS_TANGENTIAL, renderer);
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        if (this.getData().size() != 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(index, source, visible);
        PieSliceRenderer pointRendererDefault = new PieSliceRenderer(this);
        this.setPointRenderer(source, pointRendererDefault);
        this.setMapping(source, AXIS_TANGENTIAL);
    }

    public PointRenderer getPointRenderer(DataSource s) {
        return this.pointRenderers.get(s);
    }

    public void setPointRenderer(DataSource s, PointRenderer pointRenderer) {
        this.pointRenderers.put(s, pointRenderer);
    }

    @Override
    public Navigator getNavigator() {
        if (this.navigator == null) {
            this.navigator = new PiePlotNavigator(this);
        }
        return this.navigator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double getSum(DataSource source) {
        double sum;
        DataSource dataSource = source;
        synchronized (dataSource) {
            sum = (Double)source.get(1, source.getRowCount() - 1);
        }
        return sum;
    }

    public static DataSource createPieData(DataSource data) {
        return new PieData(data);
    }

    @Override
    protected void dataChanged(DataSource source, DataChangeEvent ... events) {
        super.dataChanged(source, events);
        this.autoscaleAxes();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        for (DataSource source : this.getData()) {
            this.dataUpdated(source, new DataChangeEvent[0]);
        }
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D center) {
        this.center.setLocation(center);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        Shape shape;
        double startOld = this.start;
        this.start = start;
        AxisRenderer axisRenderer = this.getAxisRenderer(AXIS_TANGENTIAL);
        if (axisRenderer != null && (shape = axisRenderer.getShape()) != null) {
            double delta = Math.toRadians(startOld - start);
            AffineTransform tx = AffineTransform.getRotateInstance(delta);
            shape = tx.createTransformedShape(shape);
            axisRenderer.setShape(shape);
        }
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        Shape shape;
        this.clockwise = clockwise;
        AxisRenderer axisRenderer = this.getAxisRenderer(AXIS_TANGENTIAL);
        if (axisRenderer != null && (shape = axisRenderer.getShape()) != null) {
            shape = GeometryUtils.reverse(shape);
            axisRenderer.setShape(shape);
        }
    }

    private static class PieData
    extends AbstractDataSource {
        private final DataSource data;

        public PieData(DataSource data) {
            this.data = data;
            data.addDataListener(new DataListener(){

                @Override
                public void dataAdded(DataSource source, DataChangeEvent ... events) {
                    this.notifyDataAdded(events);
                }

                @Override
                public void dataUpdated(DataSource source, DataChangeEvent ... events) {
                    this.notifyDataUpdated(events);
                }

                @Override
                public void dataRemoved(DataSource source, DataChangeEvent ... events) {
                    this.notifyDataRemoved(events);
                }
            });
            this.setColumnTypes(this.getColumnTypesFor(data).toArray(new Class[0]));
        }

        private List<Class<? extends Comparable<?>>> getColumnTypesFor(DataSource data) {
            LinkedList columnTypes = new LinkedList();
            for (int colIndex = 0; colIndex < data.getColumnCount(); ++colIndex) {
                Column<?> column = data.getColumn(colIndex);
                if (column.isNumeric()) {
                    columnTypes.add(Double.class);
                    columnTypes.add(Double.class);
                    columnTypes.add(Boolean.class);
                    continue;
                }
                columnTypes.add(column.getType());
            }
            return columnTypes;
        }

        @Override
        public Comparable<?> get(int col, int row) {
            Accumulation accumulatedColumnData = new Accumulation(this.data.getColumn(0));
            if (col == 0) {
                if (row == 0) {
                    return 0.0;
                }
                return PieData.get(accumulatedColumnData, row - 1);
            }
            if (col == 1) {
                return PieData.get(accumulatedColumnData, row);
            }
            if (col == 2) {
                return ((Number)((Object)this.data.get(0, row))).doubleValue() > 0.0;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.data.getRowCount();
        }

        private static <T> T get(Iterable<T> iterable, int index) {
            T element = null;
            int elementIndex = 0;
            for (T e : iterable) {
                if (elementIndex == index) {
                    element = e;
                    break;
                }
                ++elementIndex;
            }
            return element;
        }
    }

    private static class LegendSymbol
    extends AbstractLegend.AbstractSymbol {
        private final Row row;
        private final PointRenderer pointRenderer;

        public LegendSymbol(Row row, PointRenderer pointRenderer, Font font, Dimension2D symbolSize) {
            super(font, symbolSize);
            this.row = row;
            this.pointRenderer = pointRenderer;
        }

        @Override
        public void draw(DrawingContext context) {
            Rectangle2D bounds = this.getBounds();
            Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth(), bounds.getHeight());
            PointData pointData = new PointData(Arrays.asList(new Axis[]{null}), Arrays.asList(new AxisRenderer[]{null}), this.row, this.row.getIndex(), 0);
            Drawable drawable = this.pointRenderer.getPoint(pointData, shape);
            Graphics2D graphics = context.getGraphics();
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(bounds.getX(), bounds.getY());
            drawable.draw(context);
            graphics.setTransform(txOrig);
        }
    }

    public static class PiePlotLegend
    extends ValueLegend {
        private static final long serialVersionUID = 309673490751330686L;
        private final PiePlot plot;

        public PiePlotLegend(PiePlot plot) {
            this.plot = plot;
        }

        @Override
        protected Iterable<Row> getEntries(DataSource source) {
            Iterable<Row> slicesAndGaps = super.getEntries(source);
            LinkedList<Row> slices = new LinkedList<Row>();
            for (Row row : slicesAndGaps) {
                boolean isVisible;
                if (!row.isColumnNumeric(0) || !(isVisible = ((Boolean)row.get(2)).booleanValue())) continue;
                slices.add(row);
            }
            return slices;
        }

        @Override
        protected Drawable getSymbol(Row row) {
            return new LegendSymbol(row, this.plot.getPointRenderer(row.getSource()), this.plot.getFont(), this.plot.getLegend().getSymbolSize());
        }

        @Override
        protected String getLabel(Row row) {
            Number sliceStart = (Number)((Object)row.get(0));
            Number sliceEnd = (Number)((Object)row.get(1));
            Double sliceWidth = sliceEnd.doubleValue() - sliceStart.doubleValue();
            Format format = this.getLabelFormat();
            if (format == null) {
                format = NumberFormat.getInstance();
            }
            return format.format(sliceWidth);
        }
    }

    public static class PieSliceRenderer
    extends AbstractPointRenderer {
        private static final long serialVersionUID = 1135636437801090607L;
        private final PiePlot plot;
        private double outerRadius;
        private double innerRadius;
        private double gap;

        public PieSliceRenderer(PiePlot plot) {
            this.plot = plot;
            this.setValueColumn(0);
            this.setErrorColumnTop(1);
            this.setErrorColumnBottom(2);
            this.setColor(new QuasiRandomColors());
            this.outerRadius = 1.0;
            this.innerRadius = 0.0;
            this.gap = 0.0;
        }

        private Slice getSlice(PointData pointData) {
            double sliceStart = (Double)pointData.row.get(0);
            double sliceEnd = (Double)pointData.row.get(1);
            boolean sliceVisible = (Boolean)pointData.row.get(2);
            return new Slice(sliceStart, sliceEnd, sliceVisible);
        }

        public double getOuterRadius() {
            return this.outerRadius;
        }

        public void setOuterRadius(double radius) {
            this.outerRadius = radius;
        }

        public double getInnerRadius() {
            return this.innerRadius;
        }

        public void setInnerRadius(double radius) {
            this.innerRadius = radius;
        }

        public double getGap() {
            return this.gap;
        }

        public void setGap(double gap) {
            this.gap = gap;
        }

        @Override
        public Drawable getPoint(final PointData data, final Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = -1783451355453643712L;

                @Override
                public void draw(DrawingContext context) {
                    Paint paint;
                    PieSliceRenderer renderer = this;
                    Row row = data.row;
                    if (shape == null) {
                        return;
                    }
                    Slice slice = this.getSlice(data);
                    if (!slice.visible) {
                        return;
                    }
                    ColorMapper colorMapper = renderer.getColor();
                    if (colorMapper instanceof ContinuousColorMapper) {
                        double sum = plot.getSum(row.getSource());
                        if (sum == 0.0) {
                            return;
                        }
                        double sliceStartRel = slice.start / sum;
                        double sliceEndRel = slice.end / sum;
                        double coloringRel = 0.0;
                        int rows = row.getSource().getRowCount();
                        if (rows > 1) {
                            double posRel = (double)data.index / (double)(rows - 1);
                            double posRelInv = 1.0 - posRel;
                            coloringRel = posRelInv * sliceStartRel + posRel * sliceEndRel;
                        }
                        paint = ((ContinuousColorMapper)colorMapper).get(coloringRel);
                    } else {
                        paint = colorMapper.get(data.index);
                    }
                    GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
                }
            };
        }

        @Override
        public Shape getPointShape(PointData data) {
            double radiusRelInner;
            Slice slice = this.getSlice(data);
            if (!slice.visible) {
                return null;
            }
            Font font = this.getValueFont();
            double fontSize = font.getSize2D();
            PlotArea plotArea = this.plot.getPlotArea();
            double plotAreaSize = Math.min(plotArea.getWidth(), plotArea.getHeight()) / 2.0;
            double radiusRel = this.plot.getRadius();
            double radius = plotAreaSize * radiusRel;
            double radiusRelOuter = this.getOuterRadius();
            double radiusOuter = radius * radiusRelOuter;
            Row row = data.row;
            double sum = this.plot.getSum(row.getSource());
            if (sum == 0.0) {
                return null;
            }
            double sliceStartRel = slice.start / sum;
            double sliceEndRel = slice.end / sum;
            double start = this.plot.getStart();
            double sliceSpan = (sliceEndRel - sliceStartRel) * 360.0;
            double sliceStart = this.plot.isClockwise() ? start - sliceEndRel * 360.0 : start + sliceStartRel * 360.0;
            start = MathUtils.normalizeDegrees(start);
            Arc2D.Double pieSlice = new Arc2D.Double(-radiusOuter, -radiusOuter, 2.0 * radiusOuter, 2.0 * radiusOuter, sliceStart, sliceSpan, 2);
            Area doughnutSlice = new Area(pieSlice);
            double gap = this.getGap();
            if (gap > 0.0) {
                BasicStroke sliceStroke = new BasicStroke((float)(gap * fontSize));
                Area sliceContour = new Area(sliceStroke.createStrokedShape(pieSlice));
                doughnutSlice.subtract(sliceContour);
            }
            if ((radiusRelInner = this.getInnerRadius()) > 0.0 && radiusRelInner < radiusRelOuter) {
                double radiusInner = radius * radiusRelInner;
                Ellipse2D.Double inner = new Ellipse2D.Double(-radiusInner, -radiusInner, 2.0 * radiusInner, 2.0 * radiusInner);
                Area hole = new Area(inner);
                doughnutSlice.subtract(hole);
            }
            return doughnutSlice;
        }

        protected void drawValueLabel(DrawingContext context, Slice slice, double radius, Row row, int rowIndex) {
            double labelPosV;
            Double value = slice.end - slice.start;
            Format format = this.getValueFormat();
            if (format == null && value instanceof Number) {
                format = NumberFormat.getInstance();
            }
            String text = format != null ? format.format(value) : ((Object)value).toString();
            ColorMapper colors = this.getValueColor();
            Paint paint = colors.get(rowIndex);
            Font font = this.getValueFont();
            double fontSize = font.getSize2D();
            Location location = this.getValueLocation();
            double alignX = this.getValueAlignmentX();
            double alignY = this.getValueAlignmentY();
            double rotation = this.getValueRotation();
            double distance = this.getValueDistance();
            distance = MathUtils.isCalculatable(distance) ? (distance *= fontSize) : 0.0;
            double radiusRelOuter = this.getOuterRadius();
            double radiusRelInner = this.getInnerRadius();
            double radiusOuter = radius * radiusRelOuter;
            double radiusInner = radius * radiusRelInner;
            double distanceV = distance;
            if (location == Location.NORTH) {
                labelPosV = radiusOuter + distanceV;
            } else if (location == Location.SOUTH) {
                labelPosV = Math.max(radiusInner - distanceV, 0.0);
            } else {
                double sliceHeight = radiusOuter - radiusInner;
                if (2.0 * distance >= sliceHeight) {
                    alignY = 0.5;
                    distanceV = 0.0;
                }
                labelPosV = radiusInner + distanceV + alignY * (sliceHeight - 2.0 * distanceV);
            }
            double sum = this.plot.getSum(row.getSource());
            if (sum == 0.0) {
                return;
            }
            double circumference = 2.0 * labelPosV * Math.PI;
            double distanceRelH = distance / circumference;
            double sliceEndRel = slice.end / sum;
            double sliceStartRel = slice.start / sum;
            double sliceWidthRel = sliceEndRel - sliceStartRel;
            if (2.0 * distanceRelH >= sliceWidthRel) {
                alignX = 0.5;
                distanceRelH = 0.0;
            }
            double labelPosRelH = sliceStartRel + distanceRelH + alignX * (sliceWidthRel - 2.0 * distanceRelH);
            double start = this.plot.getStart();
            double angleStart = Math.toRadians(-start);
            double direction = 1.0;
            if (!this.plot.isClockwise()) {
                direction = -1.0;
            }
            double angle = angleStart + direction * labelPosRelH * 2.0 * Math.PI;
            double dirX = Math.cos(angle);
            double dirY = Math.sin(angle);
            Label label = new Label(text);
            label.setAlignmentX(1.0 - 0.5 * dirX - 0.5);
            label.setAlignmentY(0.5 * dirY + 0.5);
            label.setRotation(rotation);
            label.setColor(paint);
            label.setFont(font);
            Dimension2D sizeLabel = label.getPreferredSize();
            double anchorX = 0.5;
            double anchorY = 0.5;
            if (location == Location.NORTH || location == Location.SOUTH) {
                anchorX = dirX * sizeLabel.getWidth() / 2.0;
                anchorY = dirY * sizeLabel.getHeight() / 2.0;
                if (location == Location.SOUTH) {
                    anchorX = -anchorX;
                    anchorY = -anchorY;
                }
            }
            double x = labelPosV * dirX + anchorX - sizeLabel.getWidth() / 2.0;
            double y = labelPosV * dirY + anchorY - sizeLabel.getHeight() / 2.0;
            double w = sizeLabel.getWidth();
            double h = sizeLabel.getHeight();
            label.setBounds(x, y, w, h);
            label.draw(context);
        }

        @Override
        public Drawable getValue(final PointData data, final Shape shape) {
            AbstractDrawable drawable = new AbstractDrawable(){
                private static final long serialVersionUID = 8389872806138135038L;

                @Override
                public void draw(DrawingContext context) {
                    PieSliceRenderer renderer = this;
                    Row row = data.row;
                    if (shape == null) {
                        return;
                    }
                    Slice slice = this.getSlice(data);
                    if (!slice.visible) {
                        return;
                    }
                    PlotArea plotArea = plot.getPlotArea();
                    double plotAreaSize = Math.min(plotArea.getWidth(), plotArea.getHeight()) / 2.0;
                    double radiusRel = plot.getRadius();
                    double radius = plotAreaSize * radiusRel;
                    if (renderer.isValueVisible()) {
                        this.drawValueLabel(context, slice, radius, row, data.index);
                    }
                }
            };
            return drawable;
        }
    }

    protected static final class Slice {
        public final double start;
        public final double end;
        public final boolean visible;

        public Slice(double start, double end, boolean visible) {
            this.start = start;
            this.end = end;
            this.visible = visible;
        }
    }

    public static class PiePlotArea2D
    extends PlotArea {
        private static final long serialVersionUID = 5646816099037852271L;
        private final PiePlot plot;

        public PiePlotArea2D(PiePlot plot) {
            this.plot = plot;
        }

        @Override
        public void draw(DrawingContext context) {
            this.drawBackground(context);
            this.drawBorder(context);
            this.drawPlot(context);
            this.plot.drawLegend(context);
        }

        @Override
        protected void drawPlot(DrawingContext context) {
            Graphics2D graphics = context.getGraphics();
            Shape clipBoundsOld = graphics.getClip();
            Insets2D clipOffset = this.getClippingOffset();
            if (clipOffset != null) {
                double fontSize = this.getBaseFont().getSize2D();
                Shape clipBounds = new Rectangle2D.Double(this.getX() + clipOffset.getLeft() * fontSize, this.getY() + clipOffset.getTop() * fontSize, this.getWidth() - clipOffset.getHorizontal() * fontSize, this.getHeight() - clipOffset.getVertical() * fontSize);
                if (clipBoundsOld != null) {
                    Area clipBoundsNew = new Area(clipBoundsOld);
                    clipBoundsNew.intersect(new Area(clipBounds));
                    clipBounds = clipBoundsNew;
                }
                graphics.setClip(clipBounds);
            }
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(this.getX(), this.getY());
            Rectangle2D bounds = this.getBounds();
            Point2D center = this.plot.getCenter();
            if (center == null) {
                center = new Point2D.Double(0.5, 0.5);
            }
            graphics.translate(center.getX() * bounds.getWidth(), center.getY() * bounds.getHeight());
            for (DataSource s : this.plot.getVisibleData()) {
                Drawable point;
                Shape shape;
                PointData pointData;
                Row row;
                int rowIndex;
                int colIndex;
                if (s.getColumnCount() == 0 || (colIndex = 0) < 0 || colIndex >= s.getColumnCount() || !s.isColumnNumeric(colIndex)) continue;
                PointRenderer pointRenderer = this.plot.getPointRenderer(s);
                String[] axisNames = this.plot.getMapping(s);
                Axis axis = this.plot.getAxis(axisNames[0]);
                if (!axis.isValid()) continue;
                AxisRenderer axisRenderer = this.plot.getAxisRenderer(axisNames[0]);
                List<Axis> axes = Arrays.asList(axis);
                List<AxisRenderer> axisRenderers = Arrays.asList(axisRenderer);
                for (rowIndex = 0; rowIndex < s.getRowCount(); ++rowIndex) {
                    row = s.getRow(rowIndex);
                    pointData = new PointData(axes, axisRenderers, row, row.getIndex(), 0);
                    shape = pointRenderer.getPointShape(pointData);
                    point = pointRenderer.getPoint(pointData, shape);
                    point.setBounds(bounds);
                    point.draw(context);
                }
                for (rowIndex = 0; rowIndex < s.getRowCount(); ++rowIndex) {
                    row = s.getRow(rowIndex);
                    pointData = new PointData(axes, axisRenderers, row, row.getIndex(), 0);
                    shape = pointRenderer.getPointShape(pointData);
                    point = pointRenderer.getValue(pointData, shape);
                    point.setBounds(bounds);
                    point.draw(context);
                }
            }
            graphics.setTransform(txOrig);
            if (clipOffset != null) {
                graphics.setClip(clipBoundsOld);
            }
        }
    }

    public static class PiePlotNavigator
    extends AbstractNavigator {
        private final PiePlot plot;
        private PointND<? extends Number> centerOriginal;
        private double zoomOriginal;
        private double zoom;

        public PiePlotNavigator(PiePlot plot) {
            this.plot = plot;
            this.zoom = 1.0;
            this.setDefaultState();
        }

        @Override
        public double getZoom() {
            return this.zoom;
        }

        @Override
        public void setZoom(double zoomNew) {
            if (!this.isZoomable() || zoomNew <= 0.0 || !MathUtils.isCalculatable(zoomNew)) {
                return;
            }
            double zoomOld = this.getZoom();
            if (zoomOld == (zoomNew = MathUtils.limit(zoomNew, this.getZoomMin(), this.getZoomMax()))) {
                return;
            }
            this.zoom = zoomNew;
            this.plot.setRadius(this.zoomOriginal * this.getZoom());
        }

        @Override
        public PointND<? extends Number> getCenter() {
            Point2D center = this.plot.getCenter();
            return new PointND(new Number[]{center.getX(), center.getY()});
        }

        @Override
        public void setCenter(PointND<? extends Number> center) {
            if (center == null || !this.isPannable()) {
                return;
            }
            Point2D center2d = center.getPoint2D();
            this.plot.setCenter(center2d);
        }

        @Override
        public void pan(PointND<? extends Number> deltas) {
            PlotArea plotArea = this.plot.getPlotArea();
            PointND<? extends Number> center = this.getCenter();
            double x = center.get(0).doubleValue();
            double y = center.get(1).doubleValue();
            center.set(0, (Number)(x += deltas.get(0).doubleValue() / plotArea.getWidth()));
            center.set(1, (Number)(y += deltas.get(1).doubleValue() / plotArea.getHeight()));
            this.setCenter(center);
        }

        @Override
        public void reset() {
            this.setCenter(this.centerOriginal);
            this.setZoom(1.0);
        }

        @Override
        public void setDefaultState() {
            this.centerOriginal = this.getCenter();
            this.zoomOriginal = this.plot.getRadius();
        }
    }
}

