/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawableContainer;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Label;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.graphics.layout.EdgeLayout;
import de.erichseifert.gral.graphics.layout.OuterEdgeLayout;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.PlotArea;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.legends.Legend;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPlot
extends DrawableContainer
implements Plot,
DataListener {
    private static final long serialVersionUID = -6609155385940228771L;
    private static final float DEFAULT_TITLE_FONT_SIZE = 1.5f;
    private static final float DEFAULT_LAYOUT_GAP = 2.0f;
    private final List<DataSource> data;
    private final Set<DataSource> dataVisible = new HashSet<DataSource>();
    private final Map<String, Axis> axes = new HashMap<String, Axis>();
    private final Map<String, AxisRenderer> axisRenderers = new HashMap<String, AxisRenderer>();
    private final Map<String, Drawable> axisDrawables = new HashMap<String, Drawable>();
    private final Map<DataSource, Map<Integer, String>> columnToAxisMappingByDataSource = new HashMap<DataSource, Map<Integer, String>>();
    private final Map<String, Double> axisMin = new HashMap<String, Double>();
    private final Map<String, Double> axisMax = new HashMap<String, Double>();
    private final Label title;
    private PlotArea plotArea;
    private final Container legendContainer;
    private Legend legend;
    private Paint background;
    private transient Stroke borderStroke;
    private Paint borderColor;
    private Font font;
    private boolean legendVisible;
    private Location legendLocation;
    private double legendDistance;

    public AbstractPlot(DataSource ... series) {
        super(new EdgeLayout());
        this.data = new LinkedList<DataSource>();
        for (DataSource source : series) {
            this.add(source);
        }
        this.background = null;
        this.borderStroke = null;
        this.borderColor = Color.BLACK;
        this.font = Font.decode(null);
        this.updateBaseFont();
        this.title = new Label();
        this.title.setFont(this.font.deriveFont(1.5f * this.font.getSize2D()));
        this.add(this.title, (Object)Location.NORTH);
        this.legendContainer = new DrawableContainer(new OuterEdgeLayout(0.0));
        this.legendLocation = Location.CENTER;
        this.legendDistance = 2.0;
        this.legendVisible = false;
        this.refreshLegendLayout();
    }

    @Override
    public void draw(DrawingContext context) {
        Stroke stroke;
        Graphics2D graphics = context.getGraphics();
        Paint bg = this.getBackground();
        if (bg != null) {
            GraphicsUtils.fillPaintedShape(graphics, this.getBounds(), bg, null);
        }
        if ((stroke = this.getBorderStroke()) != null) {
            Paint fg = this.getBorderColor();
            GraphicsUtils.drawPaintedShape(graphics, this.getBounds(), fg, null, stroke);
        }
        this.drawComponents(context);
    }

    protected void drawAxes(DrawingContext context) {
        for (Drawable d : this.axisDrawables.values()) {
            if (d == null) continue;
            d.draw(context);
        }
    }

    protected void drawLegend(DrawingContext context) {
        if (!this.isLegendVisible() || this.getLegend() == null) {
            return;
        }
        this.getLegend().draw(context);
    }

    @Override
    public void layout() {
        super.layout();
        this.layoutAxes();
        this.layoutLegend();
    }

    protected void layoutAxes() {
    }

    protected void layoutLegend() {
        if (this.getPlotArea() == null) {
            return;
        }
        Container legendContainer = this.getLegendContainer();
        Rectangle2D plotBounds = this.getPlotArea().getBounds();
        legendContainer.setBounds(plotBounds);
    }

    @Override
    public Axis getAxis(String name) {
        return this.axes.get(name);
    }

    @Override
    public void setAxis(String name, Axis axis) {
        if (axis == null) {
            this.removeAxis(name);
        } else {
            this.axes.put(name, axis);
        }
    }

    @Override
    public void removeAxis(String name) {
        this.axes.remove(name);
        this.axisRenderers.remove(name);
        this.axisDrawables.remove(name);
    }

    @Override
    public Collection<String> getAxesNames() {
        return this.axes.keySet();
    }

    protected void createDefaultAxes() {
    }

    protected void createDefaultAxisRenderers() {
    }

    protected void autoscaleAxes() {
        if (this.data.isEmpty()) {
            return;
        }
        for (String axisName : this.getAxesNames()) {
            this.autoscaleAxis(axisName);
        }
    }

    @Override
    public void autoscaleAxis(String axisName) {
        Axis axis = this.getAxis(axisName);
        if (axis == null || !axis.isAutoscaled()) {
            return;
        }
        double min = this.getAxisMin(axisName);
        double max = this.getAxisMax(axisName);
        double margin = 0.0 * (max - min);
        axis.setRange(min - margin, max + margin);
    }

    @Override
    public AxisRenderer getAxisRenderer(String axisName) {
        return this.axisRenderers.get(axisName);
    }

    @Override
    public void setAxisRenderer(String axisName, AxisRenderer renderer) {
        Drawable comp = null;
        if (renderer == null) {
            this.axisRenderers.remove(axisName);
        } else {
            this.axisRenderers.put(axisName, renderer);
            Axis axis = this.getAxis(axisName);
            comp = renderer.getRendererComponent(axis);
        }
        this.setAxisComponent(axisName, comp);
        this.layout();
    }

    protected Drawable getAxisComponent(String axisName) {
        return this.axisDrawables.get(axisName);
    }

    private void setAxisComponent(String axisName, Drawable comp) {
        if (comp == null) {
            this.axisDrawables.remove(axisName);
        } else {
            this.axisDrawables.put(axisName, comp);
        }
    }

    @Override
    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    protected void setPlotArea(PlotArea plotArea) {
        if (this.plotArea != null) {
            this.remove(this.plotArea);
            this.plotArea.setBaseFont(null);
        }
        this.plotArea = plotArea;
        if (this.plotArea != null) {
            this.plotArea.setBaseFont(this.font);
            this.add(this.plotArea, (Object)Location.CENTER);
        }
    }

    @Override
    public Label getTitle() {
        return this.title;
    }

    protected Container getLegendContainer() {
        return this.legendContainer;
    }

    @Override
    public Legend getLegend() {
        return this.legend;
    }

    protected void setLegend(Legend legend) {
        if (this.legend != null) {
            this.legendContainer.remove(this.legend);
            this.legend.clear();
            this.legend.setBaseFont(null);
        }
        this.legend = legend;
        if (this.legend != null) {
            this.legend.setBaseFont(this.font);
            Location constraints = this.getLegendLocation();
            this.legendContainer.add(legend, (Object)constraints);
            for (DataSource source : this.getVisibleData()) {
                legend.add(source);
            }
        }
    }

    protected void refreshLegendLayout() {
        double absoluteLegendDistance = 0.0;
        if (MathUtils.isCalculatable(this.legendDistance)) {
            absoluteLegendDistance = this.legendDistance * (double)this.font.getSize2D();
        }
        OuterEdgeLayout layout = new OuterEdgeLayout(absoluteLegendDistance);
        this.legendContainer.setLayout(layout);
    }

    @Override
    public Paint getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Paint background) {
        this.background = background;
    }

    @Override
    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    @Override
    public void setBorderStroke(Stroke border) {
        this.borderStroke = border;
    }

    @Override
    public Paint getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Paint color) {
        this.borderColor = color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.updateBaseFont();
    }

    private void updateBaseFont() {
        float gap = 2.0f * this.font.getSize2D();
        this.getLayout().setGapX(gap);
        this.getLayout().setGapY(gap);
        if (this.plotArea != null) {
            this.plotArea.setBaseFont(this.font);
        }
        if (this.legend != null) {
            this.legend.setBaseFont(this.font);
        }
    }

    @Override
    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    @Override
    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    @Override
    public Location getLegendLocation() {
        return this.legendLocation;
    }

    @Override
    public void setLegendLocation(Location location) {
        this.legendLocation = location;
        if (this.legend != null) {
            this.legendContainer.remove(this.legend);
            this.legendContainer.add(this.legend, (Object)this.legendLocation);
        }
    }

    @Override
    public double getLegendDistance() {
        return this.legendDistance;
    }

    @Override
    public void setLegendDistance(double distance) {
        this.legendDistance = distance;
        this.refreshLegendLayout();
    }

    @Override
    public void add(DataSource source) {
        this.add(source, true);
    }

    @Override
    public void add(DataSource source, boolean visible) {
        this.add(this.data.size(), source, visible);
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        this.data.add(index, source);
        if (visible) {
            this.dataVisible.add(source);
        }
        this.autoscaleAxes();
        if (this.getLegend() != null) {
            this.getLegend().add(source);
        }
        source.addDataListener(this);
        this.invalidateAxisExtrema();
    }

    @Override
    public boolean contains(DataSource source) {
        return this.data.contains(source);
    }

    @Override
    public DataSource get(int index) {
        return this.data.get(index);
    }

    @Override
    public boolean remove(DataSource source) {
        source.removeDataListener(this);
        this.dataVisible.remove(source);
        if (this.getLegend() != null) {
            this.getLegend().remove(source);
        }
        boolean existed = this.data.remove(source);
        this.invalidateAxisExtrema();
        return existed;
    }

    @Override
    public void clear() {
        for (DataSource source : this.data) {
            source.removeDataListener(this);
        }
        this.dataVisible.clear();
        if (this.getLegend() != null) {
            this.getLegend().clear();
        }
        this.data.clear();
        this.invalidateAxisExtrema();
    }

    private String getMapping(DataSource source, int col) {
        Map<Integer, String> columnToAxisMapping = this.columnToAxisMappingByDataSource.get(source);
        String axisName = columnToAxisMapping != null ? columnToAxisMapping.get(col) : null;
        return axisName;
    }

    @Override
    public String[] getMapping(DataSource source) {
        String[] mapping = new String[source.getColumnCount()];
        for (int col = 0; col < mapping.length; ++col) {
            mapping[col] = this.getMapping(source, col);
        }
        return mapping;
    }

    @Override
    public void setMapping(DataSource source, String ... axisNames) {
        if (!this.contains(source)) {
            throw new IllegalArgumentException("Data source does not exist in plot.");
        }
        if (axisNames.length > source.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("Data source only has {0,number,integer} column, {1,number,integer} values given.", source.getColumnCount(), axisNames.length));
        }
        HashMap<Integer, String> columnToAxisMapping = new HashMap<Integer, String>();
        for (int col = 0; col < axisNames.length; ++col) {
            String axisName = axisNames[col];
            if (axisName == null) continue;
            columnToAxisMapping.put(col, axisName);
        }
        this.columnToAxisMappingByDataSource.put(source, columnToAxisMapping);
        this.invalidateAxisExtrema();
    }

    protected Double getAxisMin(String axisName) {
        Double min = this.axisMin.get(axisName);
        if (min == null) {
            this.revalidateAxisExtrema();
            min = this.axisMin.get(axisName);
        }
        if (min == null) {
            min = 0.0;
        }
        return min;
    }

    protected Double getAxisMax(String axisName) {
        Double max = this.axisMax.get(axisName);
        if (max == null) {
            this.revalidateAxisExtrema();
            max = this.axisMax.get(axisName);
        }
        if (max == null) {
            return 0.0;
        }
        return max;
    }

    @Override
    public List<DataSource> getData() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public List<DataSource> getVisibleData() {
        LinkedList<DataSource> visible = new LinkedList<DataSource>();
        for (DataSource s : this.data) {
            if (!this.dataVisible.contains(s)) continue;
            visible.add(s);
        }
        return visible;
    }

    @Override
    public boolean isVisible(DataSource source) {
        return this.dataVisible.contains(source);
    }

    @Override
    public void setVisible(DataSource source, boolean visible) {
        if (visible) {
            if (this.dataVisible.add(source)) {
                this.invalidateAxisExtrema();
            }
        } else if (this.dataVisible.remove(source)) {
            this.invalidateAxisExtrema();
        }
    }

    @Override
    public void dataAdded(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    @Override
    public void dataUpdated(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    @Override
    public void dataRemoved(DataSource source, DataChangeEvent ... events) {
        this.dataChanged(source, events);
    }

    protected void dataChanged(DataSource source, DataChangeEvent ... events) {
        this.invalidateAxisExtrema();
        this.autoscaleAxes();
        this.layout();
    }

    private void invalidateAxisExtrema() {
        this.axisMin.clear();
        this.axisMax.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateAxisExtrema() {
        AbstractPlot abstractPlot = this;
        synchronized (abstractPlot) {
            for (Map.Entry<DataSource, Map<Integer, String>> entryByDataSource : this.columnToAxisMappingByDataSource.entrySet()) {
                DataSource dataSource = entryByDataSource.getKey();
                Map<Integer, String> columnToAxisMapping = entryByDataSource.getValue();
                for (Map.Entry<Integer, String> entry : columnToAxisMapping.entrySet()) {
                    Integer colIndex = entry.getKey();
                    String axisName = entry.getValue();
                    Column<?> col = dataSource.getColumn(colIndex);
                    Double min = this.axisMin.get(axisName);
                    Double max = this.axisMax.get(axisName);
                    if (min == null || max == null) {
                        min = col.getStatistics("min");
                        max = col.getStatistics("max");
                    } else {
                        min = Math.min(min, col.getStatistics("min"));
                        max = Math.max(max, col.getStatistics("max"));
                    }
                    this.axisMin.put(axisName, min);
                    this.axisMax.put(axisName, max);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.borderStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
        for (DataSource source : this.getData()) {
            source.addDataListener(this);
        }
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.defaultWriteObject();
        out.writeObject(SerializationUtils.wrap(this.borderStroke));
        for (DataSource source : this.getData()) {
            source.addDataListener(this);
        }
    }
}

