/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.plots;

import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.IOCapabilitiesStorage;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.util.Messages;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class VectorWriter
extends IOCapabilitiesStorage
implements DrawableWriter {
    private static final Map<String, Class<?>> graphics;
    private static final String VECTORGRAPHICS2D_PACKAGE = "de.erichseifert.vectorgraphics2d";
    private final String mimeType;
    private final Class<? extends Graphics2D> graphicsClass;

    protected VectorWriter(String mimeType) {
        Class<?> gfxCls;
        this.mimeType = mimeType;
        try {
            gfxCls = graphics.get(mimeType);
        }
        catch (ClassCastException e) {
            gfxCls = null;
        }
        this.graphicsClass = gfxCls;
        if (this.graphicsClass == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported file format: {0}", mimeType));
        }
    }

    @Override
    public void write(Drawable d, OutputStream destination, double width, double height) throws IOException {
        this.write(d, destination, 0.0, 0.0, width, height);
    }

    @Override
    public void write(Drawable d, OutputStream destination, double x, double y, double width, double height) throws IOException {
        try {
            Constructor<? extends Graphics2D> constructor = this.graphicsClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            Graphics2D g = constructor.newInstance(x, y, width, height);
            Rectangle2D boundsOld = d.getBounds();
            d.setBounds(x, y, width, height);
            DrawingContext context = new DrawingContext(g, DrawingContext.Quality.QUALITY, DrawingContext.Target.VECTOR);
            d.draw(context);
            byte[] data = (byte[])this.graphicsClass.getMethod("getBytes", new Class[0]).invoke((Object)g, new Object[0]);
            destination.write(data);
            d.setBounds(boundsOld);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    static {
        Class<?> cls;
        graphics = new HashMap();
        try {
            cls = Class.forName("de.erichseifert.vectorgraphics2d.EPSGraphics2D");
            VectorWriter.addCapabilities(new IOCapabilities("EPS", Messages.getString("ImageIO.epsDescription"), "application/postscript", new String[]{"eps", "epsf", "epsi"}));
            graphics.put("application/postscript", cls);
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        try {
            cls = Class.forName("de.erichseifert.vectorgraphics2d.PDFGraphics2D");
            VectorWriter.addCapabilities(new IOCapabilities("PDF", Messages.getString("ImageIO.pdfDescription"), "application/pdf", new String[]{"pdf"}));
            graphics.put("application/pdf", cls);
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        try {
            cls = Class.forName("de.erichseifert.vectorgraphics2d.SVGGraphics2D");
            VectorWriter.addCapabilities(new IOCapabilities("SVG", Messages.getString("ImageIO.svgDescription"), "image/svg+xml", new String[]{"svg", "svgz"}));
            graphics.put("image/svg+xml", cls);
        }
        catch (ClassNotFoundException e) {
            Object var0 = null;
        }
    }
}

