/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.plots;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.plots.DrawableWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public final class DrawableWriterFactory
extends AbstractIOFactory<DrawableWriter> {
    private static DrawableWriterFactory instance;

    private DrawableWriterFactory() throws IOException {
        super("de/erichseifert/gral/resources/drawablewriters.properties");
    }

    public static DrawableWriterFactory getInstance() {
        if (instance == null) {
            try {
                instance = new DrawableWriterFactory();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    @Override
    public DrawableWriter get(String mimeType) {
        DrawableWriter writer = null;
        Class clazz = this.getTypeClass(mimeType);
        try {
            if (clazz != null) {
                Constructor constructor = clazz.getDeclaredConstructor(String.class);
                writer = (DrawableWriter)constructor.newInstance(mimeType);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (writer == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", mimeType));
        }
        return writer;
    }
}

