/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataWriter;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.Messages;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;

public class ImageWriter
extends AbstractDataWriter {
    public ImageWriter(String mimeType) {
        super(mimeType);
        this.setDefault("factor", 1.0);
        this.setDefault("offset", 0.0);
    }

    @Override
    public void write(DataSource data, OutputStream output) throws IOException {
        int w = data.getColumnCount();
        int h = data.getRowCount();
        double factor = ((Number)this.getSetting("factor")).doubleValue();
        double offset = ((Number)this.getSetting("offset")).doubleValue();
        byte[] pixelData = new byte[w * h];
        int pos = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Comparable<?> cell = data.get(x, y);
                if (!(cell instanceof Number)) continue;
                Number numericCell = (Number)((Object)cell);
                double value = numericCell.doubleValue() * factor + offset;
                byte v = (byte)Math.round(MathUtils.limit(value, 0.0, 255.0));
                pixelData[pos++] = v;
            }
        }
        BufferedImage image = new BufferedImage(w, h, 10);
        image.getRaster().setDataElements(0, 0, w, h, pixelData);
        Iterator<javax.imageio.ImageWriter> writers = ImageIO.getImageWritersByMIMEType(this.getMimeType());
        try {
            javax.imageio.ImageWriter writer = writers.next();
            writer.setOutput(ImageIO.createImageOutputStream(output));
            writer.write(image);
        }
        catch (NoSuchElementException e) {
            throw new IOException(MessageFormat.format("No writer found for MIME type {0}.", this.getMimeType()));
        }
    }

    static {
        ImageWriter.addCapabilities(new IOCapabilities("BMP", Messages.getString("ImageIO.bmpDescription"), "image/bmp", new String[]{"bmp", "dib"}));
        ImageWriter.addCapabilities(new IOCapabilities("GIF", Messages.getString("ImageIO.gifDescription"), "image/gif", new String[]{"gif"}));
        ImageWriter.addCapabilities(new IOCapabilities("JPEG/JFIF", Messages.getString("ImageIO.jpegDescription"), "image/jpeg", new String[]{"jpg", "jpeg", "jpe", "jif", "jfif", "jfi"}));
        ImageWriter.addCapabilities(new IOCapabilities("PNG", Messages.getString("ImageIO.pngDescription"), "image/png", new String[]{"png"}));
        ImageWriter.addCapabilities(new IOCapabilities("WBMP", Messages.getString("ImageIO.wbmpDescription"), "image/vnd.wap.wbmp", new String[]{"wbmp"}));
    }
}

