/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.data.DataReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

public final class DataReaderFactory
extends AbstractIOFactory<DataReader> {
    private static DataReaderFactory instance;

    private DataReaderFactory() throws IOException {
        super("de/erichseifert/gral/resources/datareaders.properties");
    }

    public static DataReaderFactory getInstance() {
        if (instance == null) {
            try {
                instance = new DataReaderFactory();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    @Override
    public DataReader get(String mimeType) {
        DataReader reader = null;
        Class clazz = this.getTypeClass(mimeType);
        try {
            if (clazz != null) {
                Constructor constructor = clazz.getDeclaredConstructor(String.class);
                reader = (DataReader)constructor.newInstance(mimeType);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (reader == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", mimeType));
        }
        return reader;
    }
}

