/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataWriter;
import de.erichseifert.gral.util.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CSVWriter
extends AbstractDataWriter {
    public static final String SEPARATOR_CHAR = "separator";

    public CSVWriter(String mimeType) {
        super(mimeType);
        if ("text/tab-separated-values".equals(mimeType)) {
            this.setDefault(SEPARATOR_CHAR, Character.valueOf('\t'));
        } else {
            this.setDefault(SEPARATOR_CHAR, Character.valueOf(','));
        }
    }

    @Override
    public void write(DataSource data, OutputStream output) throws IOException {
        Character separator = (Character)this.getSetting(SEPARATOR_CHAR);
        OutputStreamWriter writer = new OutputStreamWriter(output);
        int i = 0;
        int colCount = data.getColumnCount();
        for (Comparable cell : data) {
            writer.write(String.valueOf(cell));
            int col = i % colCount;
            if (col < colCount - 1) {
                writer.write(separator.charValue());
            } else {
                writer.write("\r\n");
            }
            ++i;
        }
        writer.close();
    }

    static {
        CSVWriter.addCapabilities(new IOCapabilities("CSV", Messages.getString("DataIO.csvDescription"), "text/csv", new String[]{"csv", "txt"}));
        CSVWriter.addCapabilities(new IOCapabilities("TSV", Messages.getString("DataIO.tsvDescription"), "text/tab-separated-values", new String[]{"tsv", "tab", "txt"}));
    }
}

