/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataReader;
import de.erichseifert.gral.util.Messages;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioReader
extends AbstractDataReader {
    public AudioReader(String mimeType) {
        super(mimeType);
        this.setDefault("factor", 1.0);
        this.setDefault("offset", 0.0);
    }

    @Override
    public DataSource read(InputStream input, Class<? extends Comparable<?>> ... types) throws IOException {
        AudioInputStream audio;
        try {
            audio = AudioSystem.getAudioInputStream(input);
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
        DataTable data = new DataTable(Double.class);
        double factor = ((Number)this.getSetting("factor")).doubleValue();
        double offset = ((Number)this.getSetting("offset")).doubleValue();
        int sampleSize = audio.getFormat().getSampleSizeInBits();
        byte[] samples = new byte[sampleSize / 8];
        while (audio.read(samples) >= 0) {
            int b = samples[0];
            if (samples.length == 1) {
                b <<= 8;
            } else if (samples.length == 2) {
                b = b & 0xFF | samples[1] << 8;
            }
            double v = factor * (double)b + offset;
            data.add(Double.valueOf(v));
        }
        return data;
    }

    static {
        AudioReader.addCapabilities(new IOCapabilities("WAV", Messages.getString("DataIO.wavDescription"), "audio/wav", new String[]{"wav"}));
    }
}

