/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics.layout;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.graphics.layout.AbstractOrientedLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedLayout
extends AbstractOrientedLayout {
    private static final long serialVersionUID = -3183337606556363756L;
    private final Constraints defaultConstraints = new Constraints(true, 0.5, 0.5);

    public StackedLayout(Orientation orientation) {
        this(orientation, 0.0, 0.0);
    }

    public StackedLayout(Orientation orientation, double gapX, double gapY) {
        super(orientation, gapX, gapY);
    }

    @Override
    public void layout(Container container) {
        block9: {
            int count;
            double width;
            double yMin;
            double xMin;
            Rectangle2D bounds;
            Dimension2D size;
            block8: {
                size = this.getPreferredSize(container);
                bounds = container.getBounds();
                Insets2D insets = container.getInsets();
                xMin = bounds.getMinX() + insets.getLeft();
                yMin = bounds.getMinY() + insets.getTop();
                width = bounds.getWidth() - insets.getLeft() - insets.getRight();
                double height = bounds.getHeight() - insets.getTop() - insets.getBottom();
                count = 0;
                if (this.getOrientation() != Orientation.HORIZONTAL) break block8;
                xMin += Math.max(bounds.getWidth() - size.getWidth(), 0.0) * this.defaultConstraints.getAlignmentX();
                for (Drawable component : container) {
                    double componentY;
                    double componentHeight;
                    if (count++ > 0) {
                        xMin += this.getGapX();
                    }
                    Dimension2D compBounds = component.getPreferredSize();
                    Constraints constraints = this.getConstraints(component, container);
                    if (constraints.isStrechted()) {
                        componentHeight = height;
                        componentY = yMin;
                    } else {
                        componentHeight = Math.min(compBounds.getHeight(), height);
                        componentY = yMin + (height - componentHeight) * constraints.getAlignmentY();
                    }
                    component.setBounds(xMin, componentY, compBounds.getWidth(), componentHeight);
                    xMin += compBounds.getWidth();
                }
                break block9;
            }
            if (this.getOrientation() != Orientation.VERTICAL) break block9;
            yMin += Math.max(bounds.getHeight() - size.getHeight(), 0.0) * this.defaultConstraints.getAlignmentY();
            for (Drawable component : container) {
                double componentX;
                double componentWidth;
                if (count++ > 0) {
                    yMin += this.getGapY();
                }
                Dimension2D compBounds = component.getPreferredSize();
                Constraints constraints = this.getConstraints(component, container);
                if (constraints.isStrechted()) {
                    componentWidth = width;
                    componentX = xMin;
                } else {
                    componentWidth = Math.min(compBounds.getWidth(), width);
                    componentX = xMin + (width - componentWidth) * constraints.getAlignmentX();
                }
                component.setBounds(componentX, yMin, componentWidth, compBounds.getHeight());
                yMin += compBounds.getHeight();
            }
        }
    }

    @Override
    public Dimension2D getPreferredSize(Container container) {
        Insets2D insets = container.getInsets();
        double width = insets.getLeft();
        double height = insets.getTop();
        int count = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double h = 0.0;
            for (Drawable component : container) {
                if (count++ > 0) {
                    width += this.getGapX();
                }
                Dimension2D itemBounds = component.getPreferredSize();
                width += itemBounds.getWidth();
                h = Math.max(height, itemBounds.getHeight());
            }
            height += h;
        } else if (this.getOrientation() == Orientation.VERTICAL) {
            double w = 0.0;
            for (Drawable component : container) {
                if (count++ > 0) {
                    height += this.getGapY();
                }
                Dimension2D itemBounds = component.getPreferredSize();
                w = Math.max(w, itemBounds.getWidth());
                height += itemBounds.getHeight();
            }
            width += w;
        }
        Dimension2D.Double bounds = new Dimension2D.Double(width += insets.getRight(), height += insets.getBottom());
        return bounds;
    }

    private Constraints getConstraints(Drawable component, Container container) {
        Object constraints = container.getConstraints(component);
        if (constraints == null || !(constraints instanceof Constraints)) {
            constraints = this.defaultConstraints;
        }
        return (Constraints)constraints;
    }

    public static class Constraints
    implements Serializable {
        private static final long serialVersionUID = -3375316557720116460L;
        private final boolean strechted;
        private final double alignmentX;
        private final double alignmentY;

        public Constraints(boolean strechted, double alignmentX, double alignmentY) {
            this.strechted = strechted;
            this.alignmentX = alignmentX;
            this.alignmentY = alignmentY;
        }

        public boolean isStrechted() {
            return this.strechted;
        }

        public double getAlignmentX() {
            return this.alignmentX;
        }

        public double getAlignmentY() {
            return this.alignmentY;
        }
    }
}

