/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.graphics.layout.Layout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DrawableContainer
extends AbstractDrawable
implements Container {
    private static final long serialVersionUID = 3741045651357559308L;
    private final Insets2D insets = new Insets2D.Double();
    private Layout layout;
    private final Queue<Drawable> components = new ConcurrentLinkedQueue<Drawable>();
    private final Map<Drawable, Object> constraints = new HashMap<Drawable, Object>();

    public DrawableContainer() {
        this(null);
    }

    public DrawableContainer(Layout layout) {
        this.layout = layout;
    }

    @Override
    public void draw(DrawingContext context) {
        this.drawComponents(context);
    }

    protected void drawComponents(DrawingContext context) {
        for (Drawable d : this) {
            d.draw(context);
        }
    }

    @Override
    public void add(Drawable drawable) {
        this.add(drawable, null);
    }

    @Override
    public void add(Drawable drawable, Object constraints) {
        if (drawable == this) {
            throw new IllegalArgumentException("A container cannot be added to itself.");
        }
        this.constraints.put(drawable, constraints);
        this.components.add(drawable);
        this.layout();
    }

    @Override
    public boolean contains(Drawable drawable) {
        return this.components.contains(drawable);
    }

    @Override
    public List<Drawable> getDrawablesAt(Point2D point) {
        return DrawableContainer.getDrawablesAt(this, point, new LinkedList<Drawable>());
    }

    @Override
    public List<Drawable> getDrawables() {
        ArrayList<Drawable> drawableList = new ArrayList<Drawable>(this.components.size());
        drawableList.addAll(this.components);
        return drawableList;
    }

    private static List<Drawable> getDrawablesAt(Container container, Point2D point, LinkedList<Drawable> previousResults) {
        if (container instanceof Drawable && container.getBounds().contains(point)) {
            previousResults.addFirst((Drawable)((Object)container));
        }
        for (Drawable component : container) {
            if (component instanceof Container) {
                DrawableContainer.getDrawablesAt((Container)((Object)component), point, previousResults);
                continue;
            }
            if (component == null || !component.getBounds().contains(point)) continue;
            previousResults.addFirst(component);
        }
        return previousResults;
    }

    @Override
    public Object getConstraints(Drawable drawable) {
        return this.constraints.get(drawable);
    }

    @Override
    public void remove(Drawable drawable) {
        this.components.remove(drawable);
        this.constraints.remove(drawable);
        this.layout();
    }

    @Override
    public Insets2D getInsets() {
        Insets2D.Double insets = new Insets2D.Double();
        ((Insets2D)insets).setInsets(this.insets);
        return insets;
    }

    @Override
    public void setInsets(Insets2D insets) {
        if (insets == this.insets || this.insets.equals(insets)) {
            return;
        }
        this.insets.setInsets(insets);
        this.layout();
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(Layout layout) {
        this.layout = layout;
        this.layout();
    }

    @Override
    public void layout() {
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.layout(this);
        }
    }

    @Override
    public Iterator<Drawable> iterator() {
        return this.components.iterator();
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        super.setBounds(bounds);
        this.layout();
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        super.setBounds(x, y, width, height);
        this.layout();
    }

    @Override
    public Dimension2D getPreferredSize() {
        Layout layout = this.getLayout();
        if (layout != null) {
            return layout.getPreferredSize(this);
        }
        return super.getPreferredSize();
    }
}

