/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.pieplot;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.PiePlot;
import de.erichseifert.gral.plots.colors.LinearGradient;
import de.erichseifert.gral.ui.InteractivePanel;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Random;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DynamicPiePlot
extends ExamplePanel
implements ChangeListener {
    private static final long serialVersionUID = 6216017404657972412L;
    private static final int SAMPLE_COUNT = 5;
    private static final Random random = new Random();
    private final DataTable data = new DataTable(Integer.class);
    private final PiePlot plot;
    private final JSlider valueCountSlider;

    public DynamicPiePlot() {
        DataSource pieData = PiePlot.createPieData(this.data);
        this.plot = new PiePlot(pieData);
        this.plot.setRadius(0.9);
        this.plot.setStart(90.0);
        this.plot.setInsets(new Insets2D.Double(20.0));
        PiePlot.PieSliceRenderer pointRenderer = (PiePlot.PieSliceRenderer)this.plot.getPointRenderer(pieData);
        pointRenderer.setGap(0.2);
        LinearGradient colors = new LinearGradient(COLOR1, COLOR2);
        pointRenderer.setColor(colors);
        InteractivePanel panel = new InteractivePanel(this.plot);
        this.add((Component)panel, "Center");
        this.setValueCount(5);
        this.valueCountSlider = new JSlider(0, 50, 5);
        this.valueCountSlider.setBorder(new EmptyBorder(15, 15, 5, 15));
        this.valueCountSlider.setMajorTickSpacing(10);
        this.valueCountSlider.setMinorTickSpacing(1);
        this.valueCountSlider.setSnapToTicks(true);
        this.valueCountSlider.setPaintTicks(true);
        this.valueCountSlider.addChangeListener(this);
        this.add((Component)this.valueCountSlider, "South");
    }

    @Override
    public String getTitle() {
        return "Pie plot";
    }

    @Override
    public String getDescription() {
        return "Pie with a changeable number of random data values";
    }

    private void setValueCount(int count) {
        if (count == this.data.getRowCount()) {
            return;
        }
        while (this.data.getRowCount() != count) {
            if (this.data.getRowCount() < count) {
                int val = random.nextInt(10) + 1;
                this.data.add(Integer.valueOf(val));
                continue;
            }
            int rowIndexLast = this.data.getRowCount() - 1;
            this.data.remove(rowIndexLast);
        }
        if (this.plot != null) {
            String title = MessageFormat.format("{0,number,integer} random values", this.data.getRowCount());
            this.plot.getTitle().setText(title);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.valueCountSlider) {
            int countNew = this.valueCountSlider.getValue();
            this.setValueCount(countNew);
            this.repaint();
        }
    }

    public static void main(String[] args) {
        new DynamicPiePlot().showInFrame();
    }
}

