/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import java.io.Serializable;
import java.util.Arrays;

public class Kernel
implements Serializable {
    private static final long serialVersionUID = 7721293471122850684L;
    private final double[] values;
    private final int offset;

    public Kernel(int offset, double[] values) {
        this.values = Arrays.copyOf(values, values.length);
        this.offset = offset;
    }

    public Kernel(double ... values) {
        this(values.length / 2, values);
    }

    public static Kernel getBinomial(double variance) {
        int size = (int)(variance * 4.0) + 1;
        return Kernel.getBinomial(size);
    }

    public static Kernel getBinomial(int size) {
        int i;
        double[] values = new double[size];
        values[0] = 1.0;
        for (i = 0; i < size - 1; ++i) {
            values[0] = values[0] / 2.0;
        }
        for (i = 0; i < size; ++i) {
            for (int j = i; j > 0; --j) {
                int n = j;
                values[n] = values[n] + values[j - 1];
            }
        }
        return new Kernel(values);
    }

    public static Kernel getUniform(int size, int offset, double value) {
        double[] values = new double[size];
        Arrays.fill(values, value);
        return new Kernel(offset, values);
    }

    public double get(int i) {
        if (i < this.getMinIndex() || i > this.getMaxIndex()) {
            return 0.0;
        }
        return this.values[i - this.getMinIndex()];
    }

    protected void set(int i, double v) {
        if (i < this.getMinIndex() || i > this.getMaxIndex()) {
            return;
        }
        this.values[i - this.getMinIndex()] = v;
    }

    public int getOffset() {
        return this.offset;
    }

    public int size() {
        return this.values.length;
    }

    public int getMinIndex() {
        return -this.getOffset();
    }

    public int getMaxIndex() {
        return this.size() - this.getOffset() - 1;
    }

    public Kernel add(double v) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] + v;
        }
        return this;
    }

    public Kernel add(Kernel k) {
        int min = this.getMinIndex();
        int max = this.getMaxIndex();
        if (this.size() > k.size()) {
            min = k.getMinIndex();
            max = k.getMaxIndex();
        }
        for (int i = min; i <= max; ++i) {
            this.set(i, this.get(i) + k.get(i));
        }
        return this;
    }

    public Kernel mul(double v) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * v;
        }
        return this;
    }

    public Kernel mul(Kernel k) {
        int min = this.getMinIndex();
        int max = this.getMaxIndex();
        if (this.size() > k.size()) {
            min = k.getMinIndex();
            max = k.getMaxIndex();
        }
        for (int i = min; i <= max; ++i) {
            this.set(i, this.get(i) * k.get(i));
        }
        return this;
    }

    public Kernel normalize() {
        double sum = 0.0;
        for (double value : this.values) {
            sum += value;
        }
        return this.mul(1.0 / sum);
    }

    public Kernel negate() {
        this.mul(-1.0);
        return this;
    }
}

