/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javolution37.javolution.io.Utf8ByteBufferWriter;
import javolution37.javolution.io.Utf8StreamWriter;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.lang.Text;
import javolution37.javolution.util.FastTable;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.sax.ContentHandler;
import javolution37.javolution.xml.sax.WriterHandler;
import org.xml.sax.SAXException;

public class ObjectWriter<T>
implements Reusable {
    static final Text JAVOLUTION_PREFIX = Text.intern("j");
    static final Text JAVOLUTION_URI = Text.intern("http://javolution.org");
    private final Utf8StreamWriter _utf8StreamWriter = new Utf8StreamWriter();
    private final Utf8ByteBufferWriter _utf8ByteBufferWriter = new Utf8ByteBufferWriter();
    private final WriterHandler _writerHandler = new WriterHandler();
    private FastTable _namespaces = new FastTable();
    private final XmlElement _xml = new XmlElement(null);
    private String _rootName;
    private boolean _areReferencesEnabled = false;
    private boolean _expandReferences = false;
    private boolean _isClassIdentifierEnabled = true;

    public void setNamespace(String prefix, String uri) {
        if (prefix.length() == 1 && prefix.charAt(0) == 'j') {
            throw new IllegalArgumentException("Prefix: \"j\" is reserved.");
        }
        this._namespaces.addLast(this.toCharSeq(prefix));
        this._namespaces.addLast(this.toCharSeq(uri));
        if (prefix.length() == 0) {
            this._xml._packagePrefixes.addLast("j");
            this._xml._packagePrefixes.addLast("");
        }
    }

    public void setPackagePrefix(String prefix, String packageName) {
        this.setNamespace(prefix, "java:" + packageName);
        this._xml._packagePrefixes.addLast(prefix);
        this._xml._packagePrefixes.addLast(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T obj, Writer writer) throws IOException {
        try {
            this._writerHandler.setWriter(writer);
            this.write(obj, this._writerHandler);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
        }
        finally {
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T obj, OutputStream out) throws IOException {
        try {
            this._utf8StreamWriter.setOutputStream(out);
            this._writerHandler.setWriter(this._utf8StreamWriter);
            this.write(obj, this._writerHandler);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
        }
        finally {
            this._utf8StreamWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T obj, ByteBuffer byteBuffer) throws IOException {
        try {
            this._utf8ByteBufferWriter.setByteBuffer(byteBuffer);
            this._writerHandler.setWriter(this._utf8ByteBufferWriter);
            this.write(obj, this._writerHandler);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
        }
        finally {
            this._utf8ByteBufferWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T obj, ContentHandler handler) throws SAXException {
        CharSequence prefix;
        int i;
        handler.startDocument();
        try {
            handler.startPrefixMapping(JAVOLUTION_PREFIX, JAVOLUTION_URI);
            i = 0;
            while (i < this._namespaces.size()) {
                prefix = (CharSequence)this._namespaces.get(i++);
                CharSequence uri = (CharSequence)this._namespaces.get(i++);
                handler.startPrefixMapping(prefix, uri);
            }
            this._xml._formatHandler = handler;
            this._xml._areReferencesEnabled = this._areReferencesEnabled;
            this._xml._expandReferences = this._expandReferences;
            this._xml._isClassIdentifierEnabled = this._isClassIdentifierEnabled;
            if (this._rootName != null) {
                this._xml.add(obj, this._rootName);
            } else {
                this._xml.add(obj);
            }
        }
        finally {
            handler.endPrefixMapping(JAVOLUTION_PREFIX);
            for (i = 0; i < this._namespaces.size(); ++i) {
                prefix = (CharSequence)this._namespaces.get(i++);
                handler.endPrefixMapping(prefix);
            }
            handler.endDocument();
            this._xml.reset();
        }
    }

    @Override
    public void reset() {
        this._xml.reset();
        this._namespaces.clear();
        this._xml._packagePrefixes.clear();
        this._areReferencesEnabled = false;
        this._expandReferences = false;
        this._isClassIdentifierEnabled = true;
    }

    private CharSequence toCharSeq(Object str) {
        if (str instanceof CharSequence) {
            return (CharSequence)str;
        }
        return Text.valueOf((String)str);
    }

    public void setReferencesEnabled(boolean enabled) {
        this._areReferencesEnabled = enabled;
    }

    public void setExpandReferences(boolean value) {
        this._expandReferences = value;
    }

    public void setClassIdentifierEnabled(boolean enabled) {
        this._isClassIdentifierEnabled = enabled;
    }

    public void setRootName(String name) {
        this._rootName = name;
    }
}

