/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.realtime.RealtimeObject;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastComparator;
import javolution37.javolution.util.FastMap;

public class FastSet<E>
extends FastCollection<E>
implements Set<E>,
Reusable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        @Override
        public Object create() {
            return new FastSet();
        }

        @Override
        public void cleanup(Object obj) {
            ((FastSet)obj).reset();
        }
    };
    private transient FastMap<E, E> _map;
    private static final long serialVersionUID = 3257563997099275574L;

    public FastSet() {
        this(new FastMap());
    }

    public FastSet(String id) {
        this(new FastMap(id));
    }

    public FastSet(int capacity) {
        this(new FastMap(capacity));
    }

    public FastSet(Set<? extends E> elements) {
        this(new FastMap(elements.size()));
        this.addAll(elements);
    }

    private FastSet(FastMap<E, E> map) {
        this._map = map;
    }

    public static <E> FastSet<E> newInstance() {
        return (FastSet)FACTORY.object();
    }

    @Override
    public final int size() {
        return this._map.size();
    }

    @Override
    public final boolean add(E value) {
        return this._map.put(value, value) == null;
    }

    @Override
    public Set<E> unmodifiable() {
        return (Set)super.unmodifiable();
    }

    @Override
    public final void clear() {
        this._map.clear();
    }

    @Override
    public final boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public final boolean remove(Object o) {
        return this._map.remove(o) == o;
    }

    @Override
    public FastCollection<E> setValueComparator(FastComparator comparator) {
        super.setValueComparator(comparator);
        this._map.setKeyComparator(comparator);
        return this;
    }

    @Override
    public void reset() {
        super.setValueComparator(FastComparator.DIRECT);
        this._map.reset();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        this._map = new FastMap(size);
        this.setValueComparator((FastComparator)stream.readObject());
        int i = size;
        while (i-- != 0) {
            this.add(stream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.size());
        stream.writeObject(this.getValueComparator());
        FastCollection.Record e = this._map.head();
        FastMap.Entry<E, E> end = this._map.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            stream.writeObject(((FastMap.Entry)e).getKey());
        }
    }

    @Override
    public final FastCollection.Record head() {
        return this._map.head();
    }

    @Override
    public final FastCollection.Record tail() {
        return this._map.tail();
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((FastMap.Entry)record).getKey();
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this._map.remove(((FastMap.Entry)record).getKey());
    }
}

