/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import java.util.EmptyStackException;
import javax.realtime.MemoryArea;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.realtime.ConcurrentContext;
import javolution37.javolution.realtime.HeapContext;
import javolution37.javolution.realtime.LocalContext;
import javolution37.javolution.realtime.PoolContext;

public abstract class Context {
    private static final ThreadLocal CURRENT = new ThreadLocal(){

        protected Object initialValue() {
            Thread thread = Thread.currentThread();
            HeapContext ctx = new HeapContext();
            ((Context)ctx)._owner = thread;
            return ctx;
        }
    };
    transient PoolContext inheritedPoolContext;
    transient LocalContext inheritedLocalContext;
    private transient Thread _owner;
    private transient Context _outer;
    private Context _inner;
    private static Context Cache = (Context)CURRENT.get();

    protected Context() {
    }

    public static Context current() {
        Context ctx = Cache;
        return ctx._owner == Thread.currentThread() ? ctx : (Cache = (Context)CURRENT.get());
    }

    public final Thread getOwner() {
        return this._owner;
    }

    public final Context getOuter() {
        return this._outer;
    }

    public void clear() {
        if (this._inner != null) {
            this._inner.clear();
        }
        this._inner = null;
    }

    protected abstract void enterAction();

    protected abstract void exitAction();

    public static void enter(Context context) {
        Context current;
        if (context._owner != null) {
            throw new IllegalStateException("Context is currently in use");
        }
        context._outer = current = Context.current();
        context._owner = current._owner;
        CURRENT.set(context);
        Cache = context;
        context.inheritedPoolContext = current.inheritedPoolContext;
        context.inheritedLocalContext = current.inheritedLocalContext;
        context.enterAction();
    }

    public static void exit(Context context) {
        if (context._owner != Thread.currentThread()) {
            throw new IllegalStateException("Context is not used by the current thread");
        }
        if (context._outer == null || context._outer._owner != context._owner) {
            throw new EmptyStackException();
        }
        try {
            context.exitAction();
        }
        finally {
            CURRENT.set(context._outer);
            Cache = context._outer;
            context._outer = null;
            context._owner = null;
        }
    }

    protected static Context enter(Class contextClass) {
        Context current;
        Context outer = current = Context.current();
        Context context = current._inner;
        while (context != null) {
            if (contextClass.equals(context.getClass())) {
                outer._inner = context._inner;
                break;
            }
            outer = context;
            context = context._inner;
        }
        if (context == null) {
            try {
                context = (Context)MemoryArea.getMemoryArea(outer).newInstance(contextClass);
            }
            catch (InstantiationException e) {
                throw new JavolutionError(e);
            }
            catch (IllegalAccessException e) {
                throw new JavolutionError(e);
            }
        }
        context._inner = current._inner;
        current._inner = context;
        context._outer = current;
        context._owner = current._owner;
        context.inheritedPoolContext = current.inheritedPoolContext;
        context.inheritedLocalContext = current.inheritedLocalContext;
        CURRENT.set(context);
        Cache = context;
        context.enterAction();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Context exit(Class contextClass) {
        Context current = Context.current();
        if (!contextClass.isInstance(current)) {
            throw new IllegalStateException("Current context is not an instance of " + contextClass);
        }
        Context outer = current._outer;
        if (outer == null || outer._owner != current._owner) {
            throw new EmptyStackException();
        }
        try {
            current.exitAction();
            Context context = current;
            return context;
        }
        finally {
            CURRENT.set(outer);
            Cache = outer;
            current._outer = null;
            current._owner = null;
        }
    }

    static void setCurrent(PoolContext context, ConcurrentContext outer) {
        context._outer = outer;
        context._owner = Thread.currentThread();
        CURRENT.set(context);
        Cache = context;
        context.inheritedPoolContext = context;
        context.inheritedLocalContext = outer.inheritedLocalContext;
    }

    static PoolContext poolContext(Thread currentThread) {
        PoolContext poolContext;
        Context ctx = Cache;
        if (ctx._owner == currentThread) {
            poolContext = ctx.inheritedPoolContext;
        } else {
            Cache = (Context)CURRENT.get();
            poolContext = Context.Cache.inheritedPoolContext;
        }
        return poolContext;
    }

    static LocalContext localContext(Thread currentThread) {
        LocalContext localContext;
        Context ctx = Cache;
        if (ctx._owner == currentThread) {
            localContext = ctx.inheritedLocalContext;
        } else {
            Cache = (Context)CURRENT.get();
            localContext = Context.Cache.inheritedLocalContext;
        }
        return localContext;
    }
}

