/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.io.Serializable;
import java.util.Map;
import javolution37.javolution.lang.Reference;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.util.FastSet;

public class PersistentReference<T>
implements Reference<T>,
Serializable {
    private static final FastSet IDENTIFIERS = new FastSet();
    private static final FastMap ID_TO_VALUE = new FastMap();
    private final String _id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentReference(String id) {
        FastSet fastSet = IDENTIFIERS;
        synchronized (fastSet) {
            if (IDENTIFIERS.contains(id)) {
                throw new IllegalArgumentException("id: " + id + " already in use");
            }
            IDENTIFIERS.add(id);
        }
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentReference(String id, T defaultValue) {
        this(id);
        FastMap fastMap = ID_TO_VALUE;
        synchronized (fastMap) {
            if (!ID_TO_VALUE.containsKey(this._id)) {
                ID_TO_VALUE.put(id, defaultValue);
            }
        }
    }

    public final String id() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        FastMap fastMap = ID_TO_VALUE;
        synchronized (fastMap) {
            return (T)ID_TO_VALUE.get(this._id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T value) {
        FastMap fastMap = ID_TO_VALUE;
        synchronized (fastMap) {
            ID_TO_VALUE.put(this._id, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimum(T value) {
        FastMap fastMap = ID_TO_VALUE;
        synchronized (fastMap) {
            if (value instanceof Comparable) {
                T prevValue = this.get();
                if (((Comparable)value).compareTo(prevValue) > 0) {
                    ID_TO_VALUE.put(this._id, value);
                }
            } else if (value instanceof Integer) {
                T prevValue = this.get();
                if ((Integer)value > (Integer)prevValue) {
                    ID_TO_VALUE.put(this._id, value);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximum(T value) {
        FastMap fastMap = ID_TO_VALUE;
        synchronized (fastMap) {
            if (value instanceof Comparable) {
                T prevValue = this.get();
                if (((Comparable)value).compareTo(prevValue) < 0) {
                    ID_TO_VALUE.put(this._id, value);
                }
            } else if (value instanceof Integer) {
                T prevValue = this.get();
                if ((Integer)value < (Integer)prevValue) {
                    ID_TO_VALUE.put(this._id, value);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public static Map values() {
        return ID_TO_VALUE.unmodifiable();
    }

    public static void put(String id, Object value) {
        ID_TO_VALUE.put(id, value);
    }

    public static void putAll(Map values) {
        ID_TO_VALUE.putAll(values);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

