/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

public final class UMath {
    private UMath() {
    }

    public static double[] base10(double arg) {
        if (arg == Double.POSITIVE_INFINITY || arg == Double.NEGATIVE_INFINITY) {
            return new double[]{arg, 0.0};
        }
        if (!(arg <= 0.0) && !(arg > 0.0)) {
            return new double[]{Double.NaN, 0.0};
        }
        if (arg == 0.0) {
            return new double[]{0.0, 0.0};
        }
        double a = Math.abs(arg);
        int i = 0;
        if (a < 1.0) {
            i = 1;
            while (a * Math.pow(10.0, ++i) < 10.0) {
            }
            return new double[]{UMath.round(arg * Math.pow(10.0, --i), 18 - i), -1 * i};
        }
        if (a < 10.0) {
            return new double[]{arg, 0.0};
        }
        i = 1;
        while (Math.pow(10.0, ++i) < a) {
        }
        return new double[]{arg / Math.pow(10.0, --i), i};
    }

    public static int closestMultiple(int value, int unit) {
        if (unit == 0) {
            return 0;
        }
        if (unit == 1 || unit == -1) {
            return value;
        }
        double uu = Math.abs(unit);
        return (int)UMath.round((double)value / uu, 0) * unit * UMath.sign(unit);
    }

    public static double round(double arg, int n) {
        if (arg == Double.POSITIVE_INFINITY || arg == Double.NEGATIVE_INFINITY) {
            return arg;
        }
        if (!(arg <= 0.0) && !(arg > 0.0)) {
            return Double.NaN;
        }
        return (double)Math.round(Math.pow(10.0, n) * arg) / Math.pow(10.0, n);
    }

    public static int sign(int arg) {
        if (arg < 0) {
            return -1;
        }
        return 1;
    }
}

