/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.util;

import com.jstatcom.model.JSCDRange;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.util.UMatrix;
import com.jstatcom.util.UStringArray;
import java.util.ArrayList;

public final class UData {
    private UData() {
    }

    public static JSCSArray appendSuffix(JSCSArray arg, String suffix, String newName) {
        if (arg == null || suffix == null || newName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return new JSCSArray(newName, UStringArray.appendSuffix(arg.stringArray(), suffix));
    }

    public static JSCNArray createDeterministic(TSDateRange range, JSCNArray dummies, boolean isIntercept, boolean isSeasDum, boolean isSeasDumCentered, boolean isTrend, String newName) {
        if (dummies == null) {
            dummies = new JSCNArray("empty");
        }
        if (isSeasDum) {
            isIntercept = true;
        }
        if (newName == null || range == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!dummies.isEmpty() && dummies.rows() != range.numOfObs()) {
            throw new IllegalArgumentException("Wrong number of observations.");
        }
        JSCNArray data = new JSCNArray(newName);
        if (!dummies.isEmpty()) {
            data.appendCols(dummies);
        }
        if (isIntercept) {
            data.appendCols(new JSCNArray("intercept", UMatrix.ones(range.numOfObs(), 1)));
        }
        if (isSeasDum) {
            data.appendCols(new JSCNArray("seasDum", range.createSeasDum(isSeasDumCentered, false)));
        }
        if (isTrend) {
            data.appendCols(new JSCNArray("trend", UMatrix.seqa(1.0, 1.0, range.numOfObs())));
        }
        return data;
    }

    public static JSCNArray createResMat(JSCNArray det, JSCNArray end, JSCNArray ex, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCNArray res = new JSCNArray("merged");
        if (det != null) {
            res.appendCols(det);
        }
        if (end != null) {
            res.appendCols(end);
        }
        if (ex != null) {
            res.appendCols(ex);
        }
        if (res.isEmpty()) {
            return new JSCNArray(name);
        }
        int m = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (int i = 0; i < res.cols(); ++i) {
            for (int j = 0; j < res.rows(); ++j) {
                if (res.intAt(j, i) != 1) continue;
                ++m;
                index.add(new Integer(i * res.rows() + j));
            }
        }
        double[][] restrictions = new double[res.cols() * res.rows()][m];
        for (int i = 0; i < index.size(); ++i) {
            restrictions[((Integer)index.get((int)i)).intValue()][i] = 1.0;
        }
        return new JSCNArray(name, restrictions);
    }

    public static JSCNArray[] createYZMat(JSCNArray detData, JSCNArray endData, JSCNArray exData, int endLags, int exLags, String yName, String zName) {
        if (detData == null || endData == null || exData == null || yName == null || zName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (endLags < 0 || exLags < 0) {
            throw new IllegalArgumentException("Argument for laglength < 0.");
        }
        if (endData.isEmpty()) {
            throw new IllegalArgumentException("No endogenous variables available.");
        }
        int k = endData.cols();
        int x = exData.cols();
        int d = detData.cols();
        if (x == 0) {
            exLags = 0;
        }
        if (d > 0 && detData.rows() != endData.rows() || x > 0 && exData.rows() != endData.rows()) {
            throw new IllegalArgumentException("Number of observations incorrect.");
        }
        int maxLags = Math.max(endLags, exLags);
        int rowsZ = k * endLags + x * (exLags + 1) + d;
        int colsZ = endData.rows() - maxLags;
        if (colsZ < 1) {
            throw new IllegalArgumentException("Too many lags for given sample (maxlags: " + maxLags + ", samplesize: " + endData.rows() + ").");
        }
        double[][] Z = new double[rowsZ][colsZ];
        int ll = 0;
        for (int t = 0; t < colsZ; ++t) {
            int l;
            for (int dd = 0; dd < d; ++dd) {
                Z[ll++][t] = detData.doubleAt(maxLags + t, dd);
            }
            for (l = 0; l < endLags; ++l) {
                for (int kk = 0; kk < k; ++kk) {
                    Z[ll++][t] = endData.doubleAt(maxLags - 1 + t - l, kk);
                }
            }
            for (l = 0; l < exLags + 1; ++l) {
                for (int xx = 0; xx < x; ++xx) {
                    Z[ll++][t] = exData.doubleAt(maxLags + t - l, xx);
                }
            }
            ll = 0;
        }
        double[][] Y = UMatrix.getDoubleRows(endData.doubleArray(), maxLags, endData.rows() - 1);
        JSCNArray[] YZ = new JSCNArray[]{new JSCNArray(yName, Y), new JSCNArray(zName, Z)};
        return YZ;
    }

    public static boolean hasFullColumnRank(JSCNArray arg, int truncationLag) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (truncationLag < 0) {
            throw new IllegalArgumentException("Lag argument < 0.");
        }
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("Argument not Matrix.");
        }
        if (arg.rows() - truncationLag < arg.cols()) {
            return false;
        }
        int rank = UMatrix.rank(UMatrix.getDoubleRows(arg.doubleArray(), truncationLag, arg.rows() - 1));
        return rank == arg.cols();
    }

    public static JSCNArray[] imp2ExpRes(JSCNArray res, JSCNArray r) {
        int i;
        int rank;
        if (res == null || r == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (res.rows() != r.rows()) {
            throw new IllegalArgumentException("Rows don't match.");
        }
        int rows = res.rows();
        if (rows > 1 && (rank = res.rank()) < res.rows()) {
            throw new IllegalArgumentException("R does not have full row rank. Not all restrictions are independent.");
        }
        int cols = res.cols();
        double[][] freeIndex = UMatrix.ones(cols, 2);
        block0: for (int i2 = 0; i2 < rows; ++i2) {
            for (int j = 0; j < cols; ++j) {
                double val = res.doubleAt(i2, j);
                if (val == 0.0 || freeIndex[j][0] != 1.0) continue;
                freeIndex[j][0] = 0.0;
                freeIndex[j][1] = i2;
                for (int k = 0; k < cols; ++k) {
                    res.setValAt(res.doubleAt(i2, k) / val, i2, k);
                }
                r.setValAt(r.doubleAt(i2, 0) / val, i2, 0);
                for (int l = 0; l < rows; ++l) {
                    if (res.doubleAt(l, j) == 0.0 || l == i2) continue;
                    val = res.doubleAt(l, j);
                    for (int k = 0; k < cols; ++k) {
                        res.setValAt(res.doubleAt(l, k) - val * res.doubleAt(i2, k), l, k);
                    }
                    r.setValAt(r.doubleAt(l, 0) - val * r.doubleAt(i2, 0), l, 0);
                }
                continue block0;
            }
        }
        if (UMatrix.getNonzeroDoubleCount(UMatrix.getDoubleCol(freeIndex, 0)) == 0) {
            return new JSCNArray[]{new JSCNArray("HMat"), new JSCNArray("eta", UMatrix.getDoubleCol(freeIndex, 0)), new JSCNArray("h", r.doubleArray())};
        }
        double[][] hMat = UMatrix.eye(cols);
        for (i = 0; i < freeIndex.length; ++i) {
            if (freeIndex[i][0] != 0.0) continue;
            int refIndex = (int)freeIndex[i][1];
            for (int j = 0; j < cols; ++j) {
                double val = res.doubleAt(refIndex, j);
                hMat[i][j] = -1.0 * val;
            }
        }
        i = 0;
        int k = 0;
        while (i < freeIndex.length) {
            if (freeIndex[i][0] == 0.0) {
                hMat = UMatrix.delCol(hMat, k--);
            }
            ++i;
            ++k;
        }
        double[] h = new double[cols];
        for (int i3 = 0; i3 < cols; ++i3) {
            if (freeIndex[i3][0] != 0.0) continue;
            h[i3] = r.doubleAt((int)freeIndex[i3][1], 0);
        }
        return new JSCNArray[]{new JSCNArray("HMat", hMat), new JSCNArray("eta", UMatrix.getDoubleCol(freeIndex, 0)), new JSCNArray("h", h)};
    }

    public static JSCNArray indexData(JSCNArray arg, String newName) {
        if (arg == null || newName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        double[][] index = arg.doubleArray();
        double[] mean = UMatrix.meanc(index);
        for (int i = 0; i < arg.cols(); ++i) {
            for (int j = 0; j < arg.rows(); ++j) {
                index[j][i] = index[j][i] / Math.abs(mean[i]) * 100.0;
            }
        }
        return new JSCNArray(newName, index);
    }

    public static JSCData[] mergeTS(JSCSArray namesOfData, String nameDat, String nameRange) {
        if (namesOfData == null || nameDat == null || nameRange == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        TS[] sel = new TS[namesOfData.rows()];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = TSHolder.getInstance().getTS(namesOfData.stringAt(i, 0));
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(sel);
        double[][] data = TS.getMergedData(sel);
        JSCData[] ret = new JSCData[]{new JSCNArray(nameDat, data), new JSCDRange(nameRange, mergedRange)};
        return ret;
    }

    public static JSCNArray[] splitDeterministics(JSCNArray dets, boolean zeroBased) {
        if (dets == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCNArray impulseIndices = new JSCNArray("impulseIndices");
        JSCNArray extImpulseIndices = new JSCNArray("extImpulseIndices");
        JSCNArray shiftIndices = new JSCNArray("shiftIndices");
        JSCNArray trendBreakIndices = new JSCNArray("trendBreakIndices");
        if (dets.isEmpty()) {
            return new JSCNArray[]{impulseIndices, extImpulseIndices, shiftIndices, trendBreakIndices};
        }
        double[][] detData = dets.doubleArray();
        for (int i = 0; i < detData[0].length; ++i) {
            double[] coli = UMatrix.getDoubleCol(detData, i);
            int numTest = UMatrix.getNonzeroDoubleCount(coli);
            if (numTest <= 0 || numTest >= detData.length) continue;
            int firstNonZero = UMatrix.getFirstNonzeroIndex(coli);
            int lastNonZero = UMatrix.getLastNonzeroIndex(coli);
            if (numTest == 1) {
                impulseIndices.appendRows(new JSCNArray("impulseIndices", firstNonZero + (zeroBased ? 0 : 1)));
                continue;
            }
            if (coli[firstNonZero] == coli[coli.length - 1]) {
                shiftIndices.appendRows(new JSCNArray("shiftIndices", firstNonZero + (zeroBased ? 0 : 1)));
                continue;
            }
            if (coli[firstNonZero] == coli[lastNonZero]) {
                extImpulseIndices.appendRows(new JSCNArray("extImpulseIndices", new double[][]{{firstNonZero + (zeroBased ? 0 : 1), lastNonZero + (zeroBased ? 0 : 1)}}));
                continue;
            }
            if (coli[firstNonZero] == coli[coli.length - 1] || coli[coli.length - 1] == 0.0) continue;
            trendBreakIndices.appendRows(new JSCNArray("trendBreakIndices", firstNonZero + (zeroBased ? 0 : 1)));
        }
        return new JSCNArray[]{impulseIndices, extImpulseIndices, shiftIndices, trendBreakIndices};
    }

    public static JSCNArray standardize(JSCNArray dat, String name) {
        if (dat == null || name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return new JSCNArray(name, UMatrix.standardize(dat.doubleArray()));
    }

    public static String stringForArray(JSCSArray data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument was null for stringForArray.");
        }
        String ret = "";
        for (int i = 0; i < data.rows(); ++i) {
            ret = ret + data.stringAt(i, 0) + " ";
        }
        return ret.trim();
    }
}

