/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.StdMessages;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public final class TSTableModel
extends AbstractTableModel {
    private Double[][] dataArray = new Double[0][0];
    private String[] namesArray = new String[1];
    private String[] rowHeader = new String[0];
    private boolean editable = true;
    private TSDate startDate = null;

    public int[] findRowIndexOf(Double val, int startIndex) {
        if (this.getRowCount() == 0) {
            throw new IllegalStateException("Nothing to search for.");
        }
        if (startIndex < 0 || startIndex > this.getRowCount() - 1) {
            startIndex = 0;
        }
        if (val == null) {
            return new int[]{-1, -1};
        }
        double minDiff = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = startIndex; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                double tmpDiff = Math.abs(this.dataArray[i][j] - val);
                if (tmpDiff == 0.0 || this.dataArray[i][j].equals(val)) {
                    return new int[]{i, i};
                }
                if (!(tmpDiff < minDiff)) continue;
                minDiff = tmpDiff;
                minIndex = i;
            }
        }
        return new int[]{-1, minIndex};
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        if (this.dataArray.length > 0) {
            return this.dataArray[0].length;
        }
        return 0;
    }

    @Override
    public String getColumnName(int col) {
        if (this.namesArray.length > 0) {
            return this.namesArray[col];
        }
        return null;
    }

    public double getDoubleValueAt(int row, int col) {
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            return this.dataArray[row][col];
        }
        return Double.NaN;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.length;
    }

    public JViewport getRowHeader(JTable table) {
        AbstractTableModel rowHModel = new AbstractTableModel(){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return TSTableModel.this.rowHeader[row];
                }
                return row + 1 + "";
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return TSTableModel.this.dataArray.length;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        JTable headerCol = new JTable(rowHModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Object value = this.getValueAt(row, column);
                boolean isSelected = this.isCellSelected(row, column);
                boolean hasFocus = false;
                return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
            }
        };
        String proto1 = this.rowHeader[this.rowHeader.length - 1];
        String proto2 = this.rowHeader.length + "";
        double sw1 = headerCol.getFontMetrics(headerCol.getFont()).stringWidth(proto1);
        double sw2 = headerCol.getFontMetrics(headerCol.getFont()).stringWidth(proto2);
        headerCol.createDefaultColumnsFromModel();
        headerCol.setBackground(Color.lightGray);
        headerCol.setSelectionBackground(Color.lightGray);
        headerCol.setColumnSelectionAllowed(false);
        headerCol.setRowSelectionAllowed(true);
        headerCol.setShowGrid(true);
        headerCol.setSelectionModel(table.getSelectionModel());
        headerCol.getColumnModel().getColumn(0).setMinWidth(new Double(sw1).intValue() + 15);
        JViewport jv = new JViewport();
        jv.setView(headerCol);
        jv.setPreferredSize(new Dimension(new Double(sw1 + sw2).intValue() + 30, 10000));
        return jv;
    }

    public TSDate getStartTSDate() {
        return this.startDate;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            return this.dataArray[row][col];
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.editable;
    }

    public void setTS(TS[] tsArray) {
        int i;
        double[][] data = TS.getMergedData(tsArray);
        this.namesArray = new String[tsArray.length];
        for (i = 0; i < tsArray.length; ++i) {
            this.namesArray[i] = tsArray[i].name();
        }
        this.dataArray = new Double[data.length][data[0].length];
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                this.dataArray[i][j] = new Double(data[i][j]);
            }
        }
        TSDateRange tsRange = TSDateRange.getMergedRange(tsArray);
        this.rowHeader = tsRange.timeAxisStringArray();
        this.startDate = tsRange.lowerBound();
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public void setArrays(Double[][] data, String[] names) {
        this.namesArray = names;
        this.dataArray = data;
        this.rowHeader = this.namesArray;
        this.startDate = null;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public void updateTable(String[] array) {
        this.namesArray = array;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        Double previousValue = (Double)this.getValueAt(row, col);
        if (obj instanceof Double) {
            this.dataArray[row][col] = (Double)obj;
            if (!previousValue.equals(this.dataArray[row][col])) {
                this.fireTableCellUpdated(row, col);
            }
            return;
        }
        String text = obj.toString().trim();
        Double val = UString.parseToNumber(obj.toString());
        if (val == null) {
            StdMessages.errorInput("Input \"" + text + "\" is not a valid number.\nThe previous value {" + previousValue + "} is restored.");
            this.dataArray[row][col] = previousValue;
        } else if (!val.equals(previousValue)) {
            this.dataArray[row][col] = val;
            this.fireTableCellUpdated(row, col);
        }
    }
}

