/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCPopupTypes;
import com.jstatcom.table.NumberDisplayTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public final class TSTable
extends JTable
implements NumberDisplayTable {
    private static final Logger log = Logger.getLogger(TSTable.class);
    private TSTableModel tSModel = new TSTableModel();
    private TableCellRenderer cellRenderer = JSCCellRendererTypes.DEFAULT;
    private JPopupMenu tablePopup = JSCPopupTypes.PRECISION;
    private MouseListener triggerPopUp = null;
    private int precision = 4;
    private boolean modelChanged = false;

    public TSTable() {
        this.initialize();
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    public TS[] getTS() {
        TSTableModel model = this.getModel();
        TS[] ret = new TS[model.getColumnCount()];
        for (int i = 0; i < model.getColumnCount(); ++i) {
            String name = model.getColumnName(i);
            double[] data = new double[model.getRowCount()];
            for (int k = 0; k < data.length; ++k) {
                data[k] = model.getDoubleValueAt(k, i);
            }
            TS orig = TSHolder.getInstance().getTS(name);
            ret[i] = orig != null ? new TS(data, name, model.getStartTSDate(), orig.type(), orig.project()) : new TS(data, name, model.getStartTSDate());
        }
        return ret;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initialize() {
        try {
            this.setName("TSTableScrollPane");
            this.setSize(197, 190);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setModel(this.tSModel);
        this.setTablePopup(this.tablePopup);
        this.setCellRenderer(this.cellRenderer);
        this.setRowSelectionAllowed(true);
    }

    public boolean isModelChanged() {
        return this.modelChanged;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int col) {
        Component c = super.prepareEditor(editor, row, col);
        if (c instanceof JTextField) {
            JTextField ed = (JTextField)c;
            ed.setHorizontalAlignment(4);
            Component cc = this.cellRenderer.getTableCellRendererComponent(this, this.getValueAt(row, col), true, true, row, col);
            if (cc instanceof JLabel) {
                ed.setText(((JLabel)cc).getText());
            }
            return ed;
        }
        return c;
    }

    @Override
    public void setCellRenderer(TableCellRenderer newCellRenderer) {
        this.cellRenderer = newCellRenderer;
        TSTableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            int n = cm.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tc = cm.getColumn(i);
                tc.setCellRenderer(this.cellRenderer);
                tc.setMinWidth(50);
            }
            this.repaint();
        }
    }

    @Override
    public void setPrecision(int newPrecision) {
        if (newPrecision < 0) {
            throw new IllegalArgumentException("Negative precision argument.");
        }
        int oldPrecision = this.precision;
        this.precision = newPrecision;
        if (oldPrecision != this.precision) {
            this.repaint();
        }
    }

    public void setTablePopup(JPopupMenu newTablePopup) {
        this.tablePopup = newTablePopup;
        if (this.tablePopup == null) {
            this.removeMouseListener(this.triggerPopUp);
        } else {
            this.triggerPopUp = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    TSTable.this.tablePopup.processMouseEvent(e, null, null);
                }
            };
            this.addMouseListener(this.triggerPopUp);
        }
    }

    public void setTS(TS[] tsArray) {
        this.tSModel.setTS(tsArray);
        this.setCellRenderer(this.cellRenderer);
        if (tsArray.length > 10) {
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(2);
        }
        this.modelChanged = false;
    }

    public void updateTable(String[] array) {
        this.tSModel.updateTable(array);
    }

    @Override
    public TSTableModel getModel() {
        return this.tSModel;
    }

    public void setArrays(Double[][] data, String[] names) {
        this.tSModel.setArrays(data, names);
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        this.tSModel.setValueAt(obj, row, col);
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        super.tableChanged(evt);
        this.modelChanged = true;
    }
}

