/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectDataTypes;
import java.util.ArrayList;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class TSProjectData
implements ProjectData {
    private JSCData[] dataArray = new JSCData[0];
    private String description = "";
    public static final XmlFormat<TSProjectData> TSProjectData_XML = new XmlFormat<TSProjectData>(TSProjectData.class){

        @Override
        public void format(TSProjectData data, XmlElement xml) {
            xml.setAttribute("description", data.getDescription());
            ArrayList<JSCData> list = new ArrayList<JSCData>();
            JSCData[] array = data.getJSCData();
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
            for (JSCData el : list) {
                xml.add(el);
            }
        }

        @Override
        public TSProjectData parse(XmlElement xml) {
            String description = xml.getAttribute("description") + "";
            ArrayList<JSCData> dataList = new ArrayList<JSCData>();
            int i = 0;
            while (xml.hasNext()) {
                dataList.add((JSCData)xml.getNext());
                ++i;
            }
            TSProjectData data = new TSProjectData();
            data.setDescription(description);
            data.setJSCData(dataList.toArray(new JSCData[dataList.size()]));
            return data;
        }
    };

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String dataDescription) {
        if (dataDescription == null) {
            dataDescription = "";
        }
        this.description = dataDescription;
    }

    private void checkData(JSCData data, JSCTypes type, int index) {
        if (data == null) {
            throw new RuntimeException("Error reading TS project data. Null data at array index " + index + ".");
        }
        if (data.type() != type || data.isEmpty()) {
            throw new RuntimeException("Error reading TS project data. Expected nonempty " + type + " at array index " + index + ", but was " + data.type() + " (empty=" + data.isEmpty() + ").");
        }
    }

    @Override
    public void setJSCData(JSCData[] dataArray) {
        if (dataArray == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        int tsCount = dataArray.length / 4;
        if (dataArray.length % 4 != 0) {
            throw new RuntimeException("Wrong number of array elements: " + dataArray.length + " not a multiple of 4.");
        }
        int k = 0;
        for (int i = 0; i < tsCount; ++i) {
            JSCData data_k = dataArray[k++];
            this.checkData(data_k, JSCTypes.STRING, k - 1);
            data_k = dataArray[k++];
            this.checkData(data_k, JSCTypes.STRING, k - 1);
            data_k = dataArray[k++];
            this.checkData(data_k, JSCTypes.DATE, k - 1);
            data_k = dataArray[k++];
            this.checkData(data_k, JSCTypes.NARRAY, k - 1);
        }
        this.dataArray = dataArray;
    }

    @Override
    public JSCData[] getJSCData() {
        return this.dataArray;
    }

    @Override
    public ProjectDataTypes getProjectDataType() {
        return ProjectDataTypes.TS_DATA;
    }
}

