/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class TSDescDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TSDescDialog.class);
    private TSList tSList = null;
    private boolean canceled = true;
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjCancel = null;
    private JButton ivjClear = null;
    private JTextArea ivjDescriptionArea = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JButton ivjOK = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public TSDescDialog() {
        this.initialize();
    }

    public TSDescDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    private void cancel_ActionEvents() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void clear_ActionEvents() {
        this.getDescriptionArea().setText("");
    }

    private void connEtoC1() {
        try {
            this.oK_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.clear_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.cancel_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setPreferredSize(new Dimension(85, 27));
                this.ivjCancel.setText("Cancel");
                this.ivjCancel.setMinimumSize(new Dimension(85, 27));
                this.ivjCancel.setMaximumSize(new Dimension(85, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancel;
    }

    private JButton getClear() {
        if (this.ivjClear == null) {
            try {
                this.ivjClear = new JButton();
                this.ivjClear.setName("Clear");
                this.ivjClear.setText("Clear");
                this.ivjClear.setMaximumSize(new Dimension(85, 27));
                this.ivjClear.setPreferredSize(new Dimension(85, 27));
                this.ivjClear.setMargin(new Insets(2, 2, 2, 2));
                this.ivjClear.setMinimumSize(new Dimension(85, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClear;
    }

    public String getDescription() {
        return this.getDescriptionArea().getText();
    }

    private JTextArea getDescriptionArea() {
        if (this.ivjDescriptionArea == null) {
            try {
                this.ivjDescriptionArea = new JTextArea();
                this.ivjDescriptionArea.setName("DescriptionArea");
                this.ivjDescriptionArea.setBounds(0, 0, 447, 197);
                this.ivjDescriptionArea.setMargin(new Insets(5, 5, 5, 5));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDescriptionArea;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
                this.getJDialogContentPane().add((Component)this.getJScrollPane1(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setPreferredSize(new Dimension(275, 50));
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.getJPanel1().add((Component)this.getOK(), this.getOK().getName());
                this.getJPanel1().add((Component)this.getClear(), this.getClear().getName());
                this.getJPanel1().add((Component)this.getCancel(), this.getCancel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(20);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getDescriptionArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JButton getOK() {
        if (this.ivjOK == null) {
            try {
                this.ivjOK = new JButton();
                this.ivjOK.setName("OK");
                this.ivjOK.setText("OK");
                this.ivjOK.setMaximumSize(new Dimension(85, 27));
                this.ivjOK.setPreferredSize(new Dimension(85, 27));
                this.ivjOK.setMinimumSize(new Dimension(85, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOK;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOK().addActionListener(this.ivjEventHandler);
        this.getClear().addActionListener(this.ivjEventHandler);
        this.getCancel().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TSDescDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(450, 250);
            this.setTitle("Description of New Dataset");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void oK_ActionEvents() {
        this.canceled = false;
        this.setVisible(false);
    }

    public void setDescription(String desc) {
        this.getDescriptionArea().setText(desc);
    }

    public void setTSList(TSList newTimeSeriesList) {
        this.tSList = newTimeSeriesList;
        TS[] sel = this.tSList.getSelectedTS();
        if (sel.length > 0) {
            this.getDescriptionArea().setText(sel[0].project().getDescription());
        }
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        this.canceled = true;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSDescDialog.this.getOK()) {
                TSDescDialog.this.connEtoC1();
            }
            if (e.getSource() == TSDescDialog.this.getClear()) {
                TSDescDialog.this.connEtoC2();
            }
            if (e.getSource() == TSDescDialog.this.getCancel()) {
                TSDescDialog.this.connEtoC3();
            }
        }
    }
}

