/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.parser.CalcEngine;
import com.jstatcom.parser.CalcFunctions;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.ts.TSProject;
import com.jstatcom.ts.TSTypes;
import com.jstatcom.util.PrintfFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class TS {
    private static final Logger log = Logger.getLogger(TS.class);
    private final int hashPartResult;
    public static final String TS_TYPE_CHANGED = "TS_TYPE_CHANGED";
    private TSDateRange tSDateRange = null;
    private double[] dataArray = new double[]{Double.NaN};
    private TSDate startTSDate = null;
    private TSProject tSProject = null;
    private String name = null;
    private final Vector<PropertyChangeListener> propertyChangeListeners = new Vector();
    private TSTypes tSType = TSTypes.ENDOGENOUS;
    private static final PrintfFormat printfFormat = new PrintfFormat(Locale.ENGLISH, "%-12s");

    public TS(double[] newObservations, String newName) {
        this(newObservations, newName, new TSDate(), null, null);
    }

    public TS(double[] newObservations, String newName, TSDate newDate) {
        this(newObservations, newName, newDate, null, null);
    }

    public TS(double[] newObservations, String newName, TSDate newDate, TSTypes tsType) {
        this(newObservations, newName, newDate, tsType, null);
    }

    public TS(double[] newObservations, String newName, TSDate newDate, TSTypes tsType, TSProject newProject) {
        this.setName(newName);
        this.setStartTSDate(newDate);
        this.setData(newObservations);
        this.setTSProject(newProject);
        this.setTSType(tsType);
        int result = 17;
        result = 37 * result + this.startTSDate.hashCode();
        for (int i = 0; i < this.dataArray.length; ++i) {
            long f = Double.doubleToLongBits(this.dataArray[i]);
            result = 37 * result + (int)(f ^ f >>> 32);
        }
        this.hashPartResult = result;
    }

    public TS(TS ts) {
        this(ts.values(), ts.name(), ts.start(), ts.type(), ts.project());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TS createDiff(int periods) {
        String thisnam;
        TSTypes type;
        double[] data;
        TSDate date;
        TS tS = this;
        synchronized (tS) {
            date = this.startTSDate;
            data = this.dataArray;
            type = this.tSType;
            thisnam = this.name;
        }
        String newName = thisnam + "_d" + Math.abs(periods);
        if (periods == date.subPeriodicity() && periods > 1) {
            newName = thisnam + "_dseas";
        }
        TS diffTS = null;
        CalcEngine parser = new CalcEngine();
        parser.putVariable(thisnam, data);
        try {
            parser.parseString(newName + "=" + thisnam + "-lagn(" + thisnam + "," + periods + ")");
            diffTS = new TS(parser.getVariable(newName), newName, date, type);
        }
        catch (Throwable ex) {
            log.error((Object)("Differencing " + periods + " periods failed."), ex);
            return null;
        }
        return diffTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TS createLog() {
        String thisnam;
        TSTypes type;
        double[] data;
        TSDate date;
        TS tS = this;
        synchronized (tS) {
            date = this.startTSDate;
            data = this.dataArray;
            type = this.tSType;
            thisnam = this.name;
        }
        String newName = thisnam + "_log";
        TS loggedTS = null;
        Stack<double[]> stack = new Stack<double[]>();
        stack.push(data);
        try {
            CalcFunctions.LOG.execute(1, stack);
            loggedTS = new TS(stack.pop(), newName, date, type);
        }
        catch (Throwable ex) {
            log.error((Object)("Taking log for " + this.name + " failed."), ex);
            return null;
        }
        return loggedTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TS)) {
            return false;
        }
        TS otherTS = (TS)o;
        boolean dataCheck = true;
        TS tS = this;
        synchronized (tS) {
            Object object = o;
            synchronized (object) {
                if (!this.startTSDate.equals(otherTS.start())) {
                    return false;
                }
                if (!this.name.equalsIgnoreCase(otherTS.name())) {
                    return false;
                }
                if (this.type() != otherTS.type()) {
                    return false;
                }
                dataCheck = this.numOfObs() == otherTS.numOfObs();
                for (int i = 0; i < this.numOfObs() && dataCheck; ++i) {
                    if (this.valueAt(i) == otherTS.valueAt(i)) continue;
                    dataCheck = false;
                }
            }
        }
        return dataCheck;
    }

    private void firePropertyChange(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propName, oldValue, newValue);
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            this.propertyChangeListeners.get(i).propertyChange(evt);
        }
    }

    public synchronized double[] values() {
        double[] retObs = new double[this.dataArray.length];
        for (int i = 0; i < this.dataArray.length; ++i) {
            retObs[i] = this.dataArray[i];
        }
        return retObs;
    }

    public synchronized double valueAt(int i) {
        if (i < 0 || i > this.dataArray.length - 1) {
            return Double.NaN;
        }
        return this.dataArray[i];
    }

    public synchronized double valueAt(TSDate date) {
        if (this.tSDateRange.encloses(date) != null) {
            return Double.NaN;
        }
        return this.dataArray[this.tSDateRange.indexForDate(date)];
    }

    public static double[][] getMergedData(TS[] tsArray) {
        TSDateRange mergedRange = tsArray[0].range();
        for (int i = 1; i < tsArray.length; ++i) {
            mergedRange = mergedRange.mergedRange(tsArray[i].range());
        }
        double[][] data = new double[mergedRange.numOfObs()][tsArray.length];
        for (int i = 0; i < mergedRange.numOfObs(); ++i) {
            TSDate currentDate = mergedRange.dateForIndex(i);
            for (int j = 0; j < tsArray.length; ++j) {
                data[i][j] = tsArray[j].valueAt(currentDate);
            }
        }
        return data;
    }

    public synchronized String name() {
        return this.name;
    }

    public synchronized int numOfObs() {
        return this.dataArray.length;
    }

    public synchronized TSDate start() {
        return this.startTSDate;
    }

    public synchronized TSDateRange range() {
        return this.tSDateRange;
    }

    public synchronized TSProject project() {
        return this.tSProject;
    }

    public synchronized TSTypes type() {
        return this.tSType;
    }

    private TSTypes guessTSType() {
        double[] obs = this.values();
        if (obs.length < 3) {
            return TSTypes.DETERMINISTIC;
        }
        double distinct1 = obs[0];
        double distinct2 = obs[0];
        double diff = Double.NaN;
        boolean diffCheck = true;
        boolean distinctCheck = true;
        boolean startingNull = obs[0] == 0.0;
        for (int i = 1; i < obs.length; ++i) {
            if (obs[i] != distinct1 && distinct1 == distinct2) {
                distinct2 = obs[i];
            }
            boolean bl = distinctCheck = obs[i] == distinct1 || obs[i] == distinct2;
            if (startingNull) {
                startingNull = obs[i - 1] == 0.0;
            } else {
                if (Double.isNaN(diff)) {
                    diff = obs[i] - obs[i - 1];
                }
                if (obs[i] != 0.0) {
                    boolean bl2 = diffCheck = Math.abs(obs[i] - obs[i - 1] - diff) < 1.0E-15;
                }
            }
            if (diffCheck || distinctCheck) continue;
            return TSTypes.ENDOGENOUS;
        }
        return TSTypes.DETERMINISTIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int result = this.hashPartResult;
        TS tS = this;
        synchronized (tS) {
            result = 37 * result + this.name.toLowerCase().hashCode();
            result = 37 * result + this.tSType.hashCode();
        }
        return result;
    }

    public void print(PrintStream p) {
        String[] timeIndex = this.range().timeAxisStringArray();
        p.println(this.name + " " + this.range());
        for (int i = 0; i < timeIndex.length; ++i) {
            p.println(printfFormat.sprintf(timeIndex[i]) + " " + this.valueAt(i));
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners.contains(listener)) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    private void setData(double[] newValues) {
        if (newValues == null) {
            return;
        }
        if (newValues.length == 0) {
            return;
        }
        int firstNonNanIndex = newValues.length - 1;
        for (int i = 0; i < newValues.length; ++i) {
            if (Double.isNaN(newValues[i])) continue;
            firstNonNanIndex = i;
            break;
        }
        if (firstNonNanIndex > newValues.length) {
            return;
        }
        int lastNonNanIndex = 0;
        for (int i = newValues.length - 1; i >= firstNonNanIndex; --i) {
            if (new Double(newValues[i]).equals(JSCConstants.NaN)) continue;
            lastNonNanIndex = i;
            break;
        }
        if (lastNonNanIndex - firstNonNanIndex + 1 < 0) {
            return;
        }
        double[] newObservations = new double[lastNonNanIndex - firstNonNanIndex + 1];
        for (int i = 0; i < newObservations.length; ++i) {
            newObservations[i] = newValues[i + firstNonNanIndex];
        }
        TSDate newDate = this.startTSDate.addPeriods(firstNonNanIndex);
        this.dataArray = newObservations;
        this.setStartTSDate(newDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String newValue) {
        String error = JSCConstants.isValidName(newValue);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        TS tS = this;
        synchronized (tS) {
            this.name = newValue;
        }
    }

    private void setStartTSDate(TSDate newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("startdate cannot be null");
        }
        this.startTSDate = newValue;
        this.tSDateRange = new TSDateRange(this.startTSDate, this.startTSDate.addPeriods(this.dataArray.length - 1));
    }

    public synchronized void setTSProject(TSProject newTSProject) {
        if (newTSProject == null) {
            newTSProject = TSProject.DEFAULT_PROJECT;
        }
        this.tSProject = newTSProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTSType(TSTypes newTSType) {
        TSTypes oldValue;
        if (newTSType == null) {
            newTSType = this.guessTSType();
        }
        TS tS = this;
        synchronized (tS) {
            oldValue = this.tSType;
            this.tSType = newTSType;
        }
        if (oldValue != newTSType) {
            this.firePropertyChange(TS_TYPE_CHANGED, this.name, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ts = new StringBuffer();
        TS tS = this;
        synchronized (tS) {
            ts.append(super.toString() + " [name=" + this.name);
            ts.append(",start=" + this.startTSDate);
            ts.append(",obs=" + this.numOfObs());
            if (this.dataArray.length > 0) {
                ts.append(",first=" + this.dataArray[0]);
                ts.append(",last=" + this.dataArray[this.dataArray.length - 1]);
            }
            ts.append(",project=" + this.project());
            ts.append(",type=" + this.type());
        }
        ts.append("]");
        return ts.toString();
    }
}

