/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.ts.TSActionTypes;
import com.jstatcom.ts.TSList;
import com.jstatcom.ts.TSListAccessor;
import com.jstatcom.ts.TSMenuTypes;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class DefaultTSListPopup
extends JPopupMenu {
    private static final DefaultTSListPopup defaultTSListPopup = new DefaultTSListPopup("DEFAULT_TSList_PopupMenu");
    private TSList tSList = null;
    private final String name;
    private final List<TSListAccessor> actionList = new ArrayList<TSListAccessor>();

    public DefaultTSListPopup(String label) {
        super(label);
        this.name = label;
        this.addTSMenu(TSMenuTypes.SET_TSTYPE);
        this.addSeparator();
        this.addTSAction(TSActionTypes.TRANSFORM);
        this.addTSAction(TSActionTypes.CREATE_DUMMY);
        this.addTSAction(TSActionTypes.EDIT_TS);
        this.addSeparator();
        this.addTSAction(TSActionTypes.DELETE);
        this.addTSAction(TSActionTypes.RENAME);
        this.addSeparator();
        this.addTSAction(TSActionTypes.SHOW_DESCRIPTION);
        this.addTSAction(TSActionTypes.SAVE_DAT);
    }

    public final void addTSAction(TSActionTypes actionType) {
        if (!this.actionList.contains(actionType)) {
            this.actionList.add(actionType);
            this.add(actionType);
        }
    }

    public final void addTSActionAt(TSActionTypes actionType, int pos) {
        if (!this.actionList.contains(actionType)) {
            if (pos < 0 || pos > this.getComponentCount()) {
                throw new IllegalArgumentException("Position " + pos + " not in [0," + this.getComponentCount() + "].");
            }
            this.actionList.add(actionType);
            this.add((Component)new JMenuItem(actionType), pos);
        }
    }

    public final void addTSMenu(TSMenuTypes tsMenu) {
        if (!this.actionList.contains(tsMenu)) {
            this.actionList.add(tsMenu);
            this.add(tsMenu);
        }
    }

    public final void addTSMenuAt(TSMenuTypes tsMenu, int pos) {
        if (!this.actionList.contains(tsMenu)) {
            if (pos < 0 || pos > this.getComponentCount()) {
                throw new IllegalArgumentException("Position " + pos + " not in [0," + this.getComponentCount() + "].");
            }
            this.actionList.add(tsMenu);
            this.add((Component)tsMenu, pos);
        }
    }

    public static DefaultTSListPopup getSharedInstance() {
        return defaultTSListPopup;
    }

    public final TSList getTSList() {
        return this.tSList;
    }

    @Override
    public void processMouseEvent(MouseEvent e, MenuElement[] path, MenuSelectionManager manager) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Component c = e.getComponent();
        if (c instanceof TSList) {
            this.tSList = (TSList)c;
            for (int i = 0; i < this.actionList.size(); ++i) {
                this.actionList.get(i).enableForTSList(this.tSList);
            }
            this.pack();
            this.show(this.tSList, e.getX(), e.getY());
        }
    }

    public final void removeAction(TSActionTypes actionType) {
        if (this.actionList.contains(actionType)) {
            this.actionList.remove(actionType);
            this.removeAll();
            for (int i = 0; i < this.actionList.size(); ++i) {
                this.add((AbstractAction)((Object)this.actionList.get(i)));
            }
        }
    }

    public final void setTSList(TSList newTsList) {
        this.tSList = newTsList;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + "[name=" + this.name);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            buffer.append("," + this.getComponent(i).getName());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

