/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.table.JSCAbstractDataTable;
import com.jstatcom.table.JSCAbstractTableModel;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCSArrayTableModel;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class JSCSArrayTable
extends JSCAbstractDataTable {
    private boolean isTransposed = false;
    private final JTextField textField = new JTextField(){

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                if (JSCSArrayTable.this.isEditing()) {
                    JSCSArrayTable.this.getCellEditor().cancelCellEditing();
                }
                e.consume();
            }
            super.processKeyEvent(e);
        }
    };
    private TableCellEditor stringEditor = new DefaultCellEditor(this.textField);

    public JSCSArrayTable() {
        this.setDefaultEditor(String.class, this.stringEditor);
        this.setCellRenderer(JSCCellRendererTypes.DEFAULT);
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JSCSArrayTable.this.stringEditor.stopCellEditing();
            }
        });
    }

    @Override
    public void setModelForJSCData(JSCData data) {
        if (data == null) {
            JSCSArrayTableModel model = new JSCSArrayTableModel(null);
            model.setTransposed(this.isDisplayTransposed());
            model.setEditable(this.isEditable());
            this.setModel(model);
        } else {
            JSCSArrayTableModel model = new JSCSArrayTableModel(new Symbol(data));
            model.setTransposed(this.isDisplayTransposed());
            model.setEditable(this.isEditable());
            this.setModel(model);
        }
    }

    @Override
    public void setModelForSymbolName(SymbolTable table, String name) {
        if (name == null || table == null) {
            JSCSArrayTableModel model = new JSCSArrayTableModel(null);
            model.setTransposed(this.isDisplayTransposed());
            model.setEditable(this.isEditable());
            this.setModel(model);
        } else {
            JSCSArrayTableModel model = new JSCSArrayTableModel(table.get(new JSCTypeDef(name, JSCTypes.SARRAY)));
            model.setTransposed(this.isDisplayTransposed());
            model.setEditable(this.isEditable());
            this.setModel(model);
        }
    }

    public JSCSArray getJSCSArray() {
        return (JSCSArray)this.getJSCData();
    }

    public boolean isDisplayTransposed() {
        return this.isTransposed;
    }

    public void setDisplayTransposed(boolean transposed) {
        if (this.getModel() instanceof JSCAbstractTableModel) {
            ((JSCSArrayTableModel)this.getModel()).setTransposed(transposed);
        }
        this.isTransposed = transposed;
    }
}

