/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.equation.CoeffTable;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCNArrayTable;
import com.jstatcom.table.NumberDisplayTable;
import com.jstatcom.util.UMatrix;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public abstract class JSCPopupTypes
extends JPopupMenu
implements ActionListener {
    private final String name;
    private Component dataTable = null;
    public static final JSCPopupTypes CLICK_01 = new JSCPopupTypes("CLICK_01"){
        {
            JMenuItem menuItem = this.add("Set to '0'");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("0");
            menuItem = this.add("Set to '*'");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("*");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(this.getDataTable() instanceof JSCNArrayTable)) {
                return;
            }
            JSCNArrayTable table = (JSCNArrayTable)this.getDataTable();
            JSCNArray dataObject = table.getJSCNArray();
            int r = dataObject.rows();
            int c = dataObject.cols();
            if (r > 0 && c > 0) {
                boolean v;
                String actionCommand = e.getActionCommand();
                if (actionCommand == null) {
                    return;
                }
                if (actionCommand.equals("0")) {
                    v = false;
                } else if (actionCommand.equals("*")) {
                    v = true;
                } else {
                    return;
                }
                if (table instanceof CoeffTable) {
                    int start;
                    CoeffTable coeffTable = (CoeffTable)table;
                    for (int i = start = coeffTable.getSubMatModel().getIndex() * coeffTable.getSubMatModel().getNumberOfColumns(); i < start + coeffTable.getSubMatModel().getNumberOfColumns(); ++i) {
                        for (int j = 0; j < dataObject.rows(); ++j) {
                            if (this.isSubsetRes(coeffTable, j, i)) continue;
                            dataObject.setValAt((double)v, j, i);
                        }
                    }
                    return;
                }
                double[][] newValues = UMatrix.ones(r, c);
                newValues = UMatrix.multiply(newValues, (double)v);
                dataObject.setVal(newValues);
            }
        }
    };
    public static final JSCPopupTypes CLICK_012 = new JSCPopupTypes("CLICK_012"){
        {
            JMenuItem menuItem = this.add("Set to '0'");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("0");
            menuItem = this.add("Set to '*'");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("*");
            menuItem = this.add("Set to '!'");
            menuItem.addActionListener(this);
            menuItem.setActionCommand("!");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(this.getDataTable() instanceof JSCNArrayTable)) {
                return;
            }
            JSCNArrayTable table = (JSCNArrayTable)this.getDataTable();
            JSCNArray dataObject = table.getJSCNArray();
            int r = dataObject.rows();
            int c = dataObject.cols();
            if (r > 0 && c > 0) {
                int v;
                String actionCommand = e.getActionCommand();
                if (actionCommand == null) {
                    return;
                }
                if (actionCommand.equals("0")) {
                    v = 0;
                } else if (actionCommand.equals("*")) {
                    v = 1;
                } else if (actionCommand.equals("!")) {
                    v = 2;
                } else {
                    return;
                }
                if (table instanceof CoeffTable) {
                    int start;
                    CoeffTable coeffTable = (CoeffTable)this.getDataTable();
                    for (int i = start = coeffTable.getSubMatModel().getIndex() * coeffTable.getSubMatModel().getNumberOfColumns(); i < start + coeffTable.getSubMatModel().getNumberOfColumns(); ++i) {
                        for (int j = 0; j < dataObject.rows(); ++j) {
                            if (this.isSubsetRes(coeffTable, j, i)) continue;
                            dataObject.setValAt(v, j, i);
                        }
                    }
                    return;
                }
                double[][] newValues = UMatrix.ones(r, c);
                newValues = UMatrix.multiply(newValues, v);
                dataObject.setVal(newValues);
            }
        }
    };
    public static final JSCPopupTypes PRECISION = new JSCPopupTypes("PRECISION"){
        private String increase = "Increase Precision";
        private String decrease = "Decrease Precision";
        private String scientific = "Scientific On/Off";
        {
            JMenuItem menuItem = this.add(this.increase);
            menuItem.addActionListener(this);
            menuItem.setActionCommand(this.increase);
            menuItem = this.add(this.decrease);
            menuItem.addActionListener(this);
            menuItem.setActionCommand(this.decrease);
            menuItem = this.add(this.scientific);
            menuItem.addActionListener(this);
            menuItem.setActionCommand(this.scientific);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            Component table = this.getDataTable();
            if (table instanceof NumberDisplayTable) {
                NumberDisplayTable nTable = (NumberDisplayTable)((Object)table);
                if (actionCommand.equals(this.increase)) {
                    int oldPrecision = nTable.getPrecision();
                    nTable.setPrecision(oldPrecision + 1);
                    return;
                }
                if (actionCommand.equals(this.decrease)) {
                    int oldPrecision = nTable.getPrecision();
                    nTable.setPrecision(Math.max(oldPrecision - 1, 0));
                    return;
                }
                if (actionCommand.equals(this.scientific)) {
                    if (nTable instanceof CoeffTable) {
                        if (nTable.getCellRenderer() == JSCCellRendererTypes.COEFF_DEFAULT) {
                            nTable.setCellRenderer(JSCCellRendererTypes.COEFF_SCIENTIFIC);
                        } else {
                            nTable.setCellRenderer(JSCCellRendererTypes.COEFF_DEFAULT);
                        }
                    } else if (nTable.getCellRenderer() == JSCCellRendererTypes.DEFAULT) {
                        nTable.setCellRenderer(JSCCellRendererTypes.SCIENTIFIC);
                    } else {
                        nTable.setCellRenderer(JSCCellRendererTypes.DEFAULT);
                    }
                }
            }
        }
    };
    public static final JSCPopupTypes PRECISION_NOSCIENTIFIC = new JSCPopupTypes("PRECISION_NOSCIENTIFIC"){
        private String increase = "Increase Precision";
        private String decrease = "Decrease Precision";
        {
            JMenuItem menuItem = this.add(this.increase);
            menuItem.addActionListener(this);
            menuItem.setActionCommand(this.increase);
            menuItem = this.add(this.decrease);
            menuItem.addActionListener(this);
            menuItem.setActionCommand(this.decrease);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            Component table = this.getDataTable();
            if (table instanceof NumberDisplayTable) {
                NumberDisplayTable nTable = (NumberDisplayTable)((Object)table);
                if (actionCommand.equals(this.increase)) {
                    int oldPrecision = nTable.getPrecision();
                    nTable.setPrecision(oldPrecision + 1);
                    return;
                }
                if (actionCommand.equals(this.decrease)) {
                    int oldPrecision = nTable.getPrecision();
                    nTable.setPrecision(Math.max(oldPrecision - 1, 0));
                    return;
                }
            }
        }
    };

    protected JSCPopupTypes(String name) {
        this.name = name;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final Component getDataTable() {
        return this.dataTable;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected final boolean isSubsetRes(CoeffTable table, int row, int col) {
        JSCNArray subsetRes = table.getJSCNArraySubsetRes();
        if (subsetRes != null && row < subsetRes.rows() && col < subsetRes.cols()) {
            return subsetRes.intAt(row, col) == 0;
        }
        return false;
    }

    @Override
    public void processMouseEvent(MouseEvent e, MenuElement[] path, MenuSelectionManager manager) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Component c = e.getComponent();
        if (c instanceof NumberDisplayTable) {
            this.setDataTable(c);
            this.pack();
            this.show(c, e.getX(), e.getY());
        }
    }

    public final void setDataTable(Component newDataTable) {
        this.dataTable = newDataTable;
    }

    @Override
    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + "[name=" + this.name);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            buffer.append("," + this.getComponent(i).getName());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

