/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.component.NumberFormatTypes;
import com.jstatcom.equation.CoeffTable;
import com.jstatcom.equation.VarNamesVector;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.table.JSCAbstractDataTable;
import com.jstatcom.table.JSCNArrayTable;
import com.jstatcom.table.JSCSArrayTable;
import com.jstatcom.table.NumberDisplayTable;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class JSCCellRendererTypes
extends JLabel
implements TableCellRenderer {
    private static final String space = " ";
    private final NumberFormat numberFormat = NumberFormatTypes.DEFAULT.getInstance();
    private static final Double doubleNAN = new Double(Double.NaN);
    private final String name;
    public static final JSCCellRendererTypes DEFAULT = new JSCCellRendererTypes("DEFAULT"){

        @Override
        protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setHorizontalAlignment(4);
        }
    };
    public static final JSCCellRendererTypes SCIENTIFIC = new JSCCellRendererTypes("SCIENTIFIC"){
        private final NumberFormat scienceFormat = NumberFormatTypes.SCIENTIFIC.getInstance();

        @Override
        protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setDoubleValue(double value, NumberDisplayTable table) {
            if (new Double(value).equals(doubleNAN)) {
                this.setText(value + JSCCellRendererTypes.space);
            } else {
                if (table != null) {
                    this.scienceFormat.setMaximumFractionDigits(table.getPrecision());
                    this.scienceFormat.setMinimumFractionDigits(table.getPrecision());
                }
                this.setText(this.scienceFormat.format(value) + JSCCellRendererTypes.space);
            }
        }
    };
    public static final JSCCellRendererTypes COEFF_DEFAULT = new JSCCellRendererTypes("COEFF_DEFAULT"){
        private final NumberFormat numberFormat = NumberFormatTypes.DEFAULT.getInstance();

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double value, NumberDisplayTable table) {
            if (new Double(value).equals(doubleNAN) || value == 0.0) {
                this.setText("--- ");
            } else {
                if (table != null) {
                    this.numberFormat.setMaximumFractionDigits(table.getPrecision());
                    this.numberFormat.setMinimumFractionDigits(table.getPrecision());
                }
                this.setText(this.numberFormat.format(value) + JSCCellRendererTypes.space);
            }
        }
    };
    public static final JSCCellRendererTypes COEFF_SCIENTIFIC = new JSCCellRendererTypes("COEFF_SCIENTIFIC"){
        private final NumberFormat numberFormat = NumberFormatTypes.SCIENTIFIC.getInstance();

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double value, NumberDisplayTable table) {
            if (new Double(value).equals(doubleNAN) || value == 0.0) {
                this.setText("--- ");
            } else {
                if (table != null) {
                    this.numberFormat.setMaximumFractionDigits(table.getPrecision());
                    this.numberFormat.setMinimumFractionDigits(table.getPrecision());
                }
                this.setText(this.numberFormat.format(value) + JSCCellRendererTypes.space);
            }
        }
    };
    public static final JSCCellRendererTypes SUBSET_01 = new JSCCellRendererTypes("SUBSET_01"){
        {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("*");
            } else {
                this.setText("---");
            }
        }
    };
    public static final JSCCellRendererTypes SUBSET_01_GRAY = new JSCCellRendererTypes("SUBSET_01_GRAY"){
        {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            this.setBackground(Color.lightGray);
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("*");
            } else {
                this.setText("---");
            }
        }
    };
    public static final JSCCellRendererTypes SUBSET_012 = new JSCCellRendererTypes("SUBSET_012"){
        {
            this.setHorizontalAlignment(0);
        }

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("*");
            } else if (d == 2.0) {
                this.setText("!");
            } else {
                this.setText("---");
            }
        }
    };
    public static final JSCCellRendererTypes DIAGONAL_01 = new JSCCellRendererTypes("DIAGONAL_01"){
        boolean onDiagonal = false;
        private final NumberFormat numberFormat = NumberFormatTypes.DEFAULT.getInstance();
        {
            this.setHorizontalAlignment(0);
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumFractionDigits(0);
        }

        @Override
        protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
            this.onDiagonal = row == col;
        }

        @Override
        protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
            int convertCol = table.convertColumnIndexToModel(col);
            if (this.isSubsetRes(table, row, convertCol)) {
                return Double.NaN;
            }
            return table.getJSCNArray().doubleAt(row, convertCol);
        }

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            if (this.onDiagonal) {
                this.setBackground(Color.lightGray);
                this.setText(this.numberFormat.format(d));
                return;
            }
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("*");
            } else {
                this.setText("---");
            }
        }
    };
    public static final JSCCellRendererTypes EQUATION_NAMES = new JSCCellRendererTypes("EQUATION_NAMES"){
        {
            this.setHorizontalAlignment(2);
        }

        @Override
        public void setStringValue(String arg) {
            this.setText(" \"" + arg + "\" - Equation" + JSCCellRendererTypes.space);
        }
    };
    public static final JSCCellRendererTypes VARIABLE_NAMES = new JSCCellRendererTypes("VARIABLE_NAMES"){
        private VarNamesVector namesVector = null;
        {
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setStringValue(String text) {
            if (text == null) {
                this.setText(" null ");
                return;
            }
            if (this.namesVector == null) {
                this.setText(JSCCellRendererTypes.space + text + JSCCellRendererTypes.space);
                return;
            }
            if (this.namesVector.isShowingTimeIndex() && !text.equals("CONST")) {
                text = text + this.namesVector.getIndexString();
            }
            this.setText(JSCCellRendererTypes.space + text + JSCCellRendererTypes.space);
        }

        @Override
        protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
            this.namesVector = table instanceof VarNamesVector ? (VarNamesVector)table : null;
        }
    };
    public static final JSCCellRendererTypes DIAG_01M1NEGINF = new JSCCellRendererTypes("DIAG_01M1NEGINF"){
        boolean onDiagonal = false;

        @Override
        protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
            this.onDiagonal = row == col;
        }

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            this.setHorizontalAlignment(0);
            if (this.onDiagonal) {
                this.setBackground(Color.lightGray);
            }
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("1");
            } else if (d == -1.0) {
                this.setText("-1");
            } else if (d == Double.NEGATIVE_INFINITY) {
                this.setText("*");
            } else {
                this.setHorizontalAlignment(4);
                super.setDoubleValue(d, table);
            }
        }
    };
    public static final JSCCellRendererTypes SUBSET_01M1NEGINF = new JSCCellRendererTypes("SUBSET_01M1NEGINF"){

        @Override
        protected void setDoubleValue(double d, NumberDisplayTable table) {
            this.setHorizontalAlignment(0);
            if (d == 0.0) {
                this.setText("0");
            } else if (d == 1.0) {
                this.setText("1");
            } else if (d == -1.0) {
                this.setText("-1");
            } else if (d == Double.NEGATIVE_INFINITY) {
                this.setText("*");
            } else {
                this.setHorizontalAlignment(4);
                super.setDoubleValue(d, table);
            }
        }
    };

    protected JSCCellRendererTypes(String name) {
        this.name = name;
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    protected double getDoubleValue(JSCNArrayTable table, int row, int col) {
        int convertCol = table.convertColumnIndexToModel(col);
        return table.getJSCNArray().doubleAt(row, convertCol);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected String getStringValue(JSCSArrayTable table, int row, int col) {
        int convertCol = table.convertColumnIndexToModel(col);
        if (table.isDisplayTransposed()) {
            return table.getJSCSArray().stringAt(convertCol, row);
        }
        return table.getJSCSArray().stringAt(row, convertCol);
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setFirst(table, isSelected, hasFocus, row, col);
        if (this.isEnabled() != table.isEnabled()) {
            this.setEnabled(table.isEnabled());
        }
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (table instanceof JSCAbstractDataTable) {
            JSCAbstractDataTable dataTable = (JSCAbstractDataTable)table;
            if (dataTable instanceof JSCNArrayTable) {
                JSCNArrayTable nArrayTable = (JSCNArrayTable)dataTable;
                double d = this.getDoubleValue(nArrayTable, row, col %= dataTable.getColumnCount());
                this.setDoubleValue(d, nArrayTable);
            } else if (dataTable instanceof JSCSArrayTable) {
                JSCSArrayTable sArrayTable = (JSCSArrayTable)dataTable;
                String s = this.getStringValue(sArrayTable, row, col);
                this.setStringValue(s);
            } else {
                this.setValue(dataTable.getValueAt(row, col), dataTable);
            }
        } else {
            this.setValue(table.getValueAt(row, col), table);
        }
        return this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected boolean isSubsetRes(JSCNArrayTable table, int row, int col) {
        if (!(table instanceof CoeffTable)) {
            return false;
        }
        JSCNArray subsetRes = ((CoeffTable)table).getJSCNArraySubsetRes();
        if (subsetRes != null && row < subsetRes.rows() && col < subsetRes.cols()) {
            return subsetRes.intAt(row, col) == 0;
        }
        return false;
    }

    protected void setDoubleValue(double value, NumberDisplayTable table) {
        if (new Double(value).equals(doubleNAN)) {
            this.setText(value + space);
        } else {
            if (table != null) {
                this.numberFormat.setMaximumFractionDigits(table.getPrecision());
                this.numberFormat.setMinimumFractionDigits(table.getPrecision());
            }
            this.setText(this.numberFormat.format(value) + space);
        }
    }

    protected void setFirst(JTable table, boolean isSelected, boolean hasFocus, int row, int col) {
    }

    protected void setStringValue(String value) {
        this.setText(value == null ? "" : space + value + space);
    }

    private void setValue(Object value, JTable table) {
        if (table instanceof NumberDisplayTable) {
            this.setDoubleValue((Double)value, (NumberDisplayTable)((Object)table));
        } else if (value != null) {
            this.setStringValue(value.toString() + space);
        } else {
            this.setText("");
        }
    }

    @Override
    public final String toString() {
        return this.name;
    }
}

